package cn.com.duiba.galaxy.sdk;

import cn.com.duiba.galaxy.common.message.BizError;
import cn.com.duiba.galaxy.common.message.SystemModuleEnum;
import cn.com.duiba.galaxy.common.message.TmpDescBizError;
import org.apache.commons.lang3.StringUtils;

/**
 * 平台业务模块错误枚举
 *
 * @author fangxiaorun
 * @date 2022/09/28
 */
public enum PlatformSdkErrorEnum implements BizError {

    PARAM_ERROR("102", "参数错误"),

    LOCK_ERROR("600", "锁获取失败"),



    ;

    /**
     * 自定义编码
     */
    private final String nodeCode;

    /**
     * 描述
     */
    private String desc;

    PlatformSdkErrorEnum(String nodeCode, String desc) {
        this.nodeCode = nodeCode;
        this.desc = desc;
    }

    /**
     * 获取场景类型
     *
     * @return {@link SystemModuleEnum}
     */
    @Override
    public SystemModuleEnum getBizScene() {
        return SystemModuleEnum.PLATFORM_CORE;
    }

    /**
     * 获取自定义编码（错误码通过方法{@link BizError#getCode()}获取）
     *
     * @return {@link String}
     */
    @Override
    public String getNodeCode() {
        return nodeCode;
    }

    /**
     * 获取描述信息
     *
     * @return {@link String}
     */
    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * 对指定错误类型修改描述
     *
     * @return {@link PlatformSdkErrorEnum}
     */
    public BizError setDesc(String errorMsg) {
        if (StringUtils.isNotEmpty(errorMsg)) {
            BizError tmpError = new TmpDescBizError(this,errorMsg);
            return tmpError;
        }
        return this;
    }
}
