package cn.com.duiba.galaxy.sdk;

import cn.com.duiba.galaxy.sdk.api.base.ActionContext;
import cn.com.duiba.galaxy.sdk.api.base.UserRequestContext;
import cn.com.duiba.galaxy.sdk.api.credits.CreditsApi;
import cn.com.duiba.galaxy.sdk.api.pay.PayApi;
import cn.com.duiba.galaxy.sdk.api.playway.score.ScoreUserRequestApi;
import cn.com.duiba.galaxy.sdk.api.prize.PrizeApi;
import cn.com.duiba.galaxy.sdk.api.redis.RedisApi;
import cn.com.duiba.galaxy.sdk.api.tools.ToolsApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.DistributedLock;
import cn.com.duiba.galaxy.sdk.api.tools.inner.lock.LockApi;
import cn.com.duiba.galaxy.sdk.api.tools.inner.logger.BuriedPointService;
import cn.com.duiba.galaxy.sdk.api.tools.inner.transaction.ProjectTransactionApi;
import cn.com.duiba.galaxy.sdk.api.user.ConsumerApi;
import cn.com.duiba.galaxy.sdk.apiextra.KeyValueApi;
import cn.com.duiba.galaxy.sdk.apiextra.QueryTableApi;
import cn.com.duiba.galaxy.sdk.apiextra.SMSValidateApi;
import cn.com.duiba.galaxy.sdk.apiextra.UserDataApi;
import cn.com.duiba.galaxy.sdk.apiextra.UserMarkApi;
import cn.com.duiba.galaxy.sdk.apiextra.inner.Field;
import cn.com.duiba.galaxy.sdk.component.ComponentApi;

/**
 * 用户请求作用域内可使用的API
 * CustomRequestAction下的api
 * @author xuhengfei
 */
public interface UserRequestApi extends UserRequestContext {

    /**
     * 获取当前活动的用户锁，可重入
     * @return
     */
    DistributedLock getMyLock();

    /**
     * 获取action的上下文
     * @return
     */
    ActionContext getActionContext();

    /**
     * 键值对api
     * @return
     */
    KeyValueApi getKeyValueApi();

    /**
     * 积分相关api
     * @return
     */
    CreditsApi getCreditsApi();

    /**
     * 奖品相关api
     * @return
     */
    PrizeApi getPrizeApi();

    /**
     * 工具类api
     * @return
     */
    ToolsApi getToolsApi();

    /**
     * 获取RedisAPi
     */
    RedisApi getRedisApi();

    /**
     * 获取锁Api
     * @return
     */
    LockApi getLockApi();

    /**
     * 埋点api
     * @return
     */
    BuriedPointService getBuriedPointService();

    /**
     * 手动事务api
     * @return
     */
    ProjectTransactionApi getTransactionApi();

    /**
     * 获取组件api
     * @return
     */
    ComponentApi getComponentApi();

    ScoreUserRequestApi getScoreUserRequestApi();


    /**
     * 获得userDateApi
     * @return
     */
    UserDataApi getUserDataApi();


    /**
     * 获得用户数据api
     * @return
     */
    <T extends Field> QueryTableApi<T> getQueryTableApi(String group, Class<T> clazz);


    /**
     * 新老用户标识api
     * @return
     */
    UserMarkApi getUserMarkApi();

    /**
     * 获取用户api
     *
     * @return {@link ConsumerApi}
     */
    ConsumerApi getConsumerApi();

    SMSValidateApi getSMSValidateApi();

    /**
     * 获取支付api
     * @return
     */
    PayApi getPayApi();

}
