package cn.com.duiba.galaxy.sdk.api.base;

import cn.com.duiba.galaxy.sdk.api.prize.inner.Option;
import cn.com.duiba.wolf.entity.Pair;

import java.util.Date;
import java.util.List;

/**
 * 星速台项目上下文
 * 所有扩展的内部上下文都需要继承该接口
 *
 * @author zhangruofan
 * @date 2020/04/21
 */
public interface ProjectContext {

    /**
     * 获取项目开始时间、结束时间
     */
    Pair<Date, Date> getProjectTime();

    /**
     * 获取当前活动appId
     * @return
     */
    Long getAppId();


    /**
     * 获取运营配置的变量Integer
     *
     * @param key 配置项Variable
     * @return 变量对应的int值
     */
    Integer getIntVariable(String key);

    /**
     * 获取运营配置变量String
     *
     * @param key 配置项Variable
     * @return 变量对应的String值
     */
    String getStringVariable(String key);

    /**
     * 获取运营配置变量Date
     *
     * @param key 配置项Variable
     * @return 变量对应的Date值
     */
    Date getDateVariable(String key);


    /**
     * get project id
     *
     * @return project id
     */
    Long getProjectId();


    /**
     * 查询选项
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @param vipLevel   vip水平
     * @param forInner   对内部 true 内部使用
     * @return list
     */
    List<Option> queryOptions(String strategyId, Integer vipLevel,boolean forInner);




}
