package cn.com.duiba.galaxy.sdk.api.http.inner;


import cn.com.duiba.galaxy.sdk.api.base.UserRequestContext;

/**
 * Http异步回
 */
public interface HttpCallback {

    /**
     * Http请求成功的回调
     *
     * @param context    上下文
     * @param result http返回的结果
     */
    public void completed(UserRequestContext context, String result);

    /**
     * Http请求失败回调
     *
     * @param context 上下文
     * @param e   http请求异常信息
     */
    public void failed(UserRequestContext context, Exception e);
}
