package cn.com.duiba.galaxy.sdk.api.pay.third.api;

import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifeAppPayReq;
import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifeAppPayResp;
import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifePayNotifyResp;
import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifeWxPayQueryResp;
import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifeWxPayReq;
import cn.com.duiba.galaxy.sdk.api.pay.third.icbc.elife.IcbcElifeWxPayResp;

import java.util.Map;

/**
 * Created by HePeng on 2022/06/13 11:12.
 */
public interface IcbcElifePayApi {

    /**
     * 工行e生活支付，app端
     * @param request
     * @return
     */
    IcbcElifeAppPayResp createIcbcElifeCharge4App(IcbcElifeAppPayReq request);

    /**
     * 工行e生活支付，微信端
     * @param request
     * @return
     */
    IcbcElifeWxPayResp createIcbcElifeCharge4Wx(IcbcElifeWxPayReq request);

    /**
     * 工行e生活支付，回调通知，app端
     * @param notifyUrl
     * @param params
     * @return
     */
    IcbcElifePayNotifyResp orderNotify4App(String notifyUrl, Map<String, String> params);

    /**
     * 工行e生活支付，回调通知，微信端
     * @param notifyUrl
     * @param params
     * @return
     */
    IcbcElifePayNotifyResp orderNotify4Wx(String notifyUrl, Map<String, String> params);

    /**
     * 工行e生活支付，查询订单状态，微信端
     * @param payRecordId
     * @return
     */
    IcbcElifeWxPayQueryResp queryOrderStatus4Wx(Long payRecordId, String projectId);

    /**
     * 工行e生活支付结果查询
     * @param payRecordId
     * @return
     */
    int queryPayStatus(Long payRecordId);

}
