package cn.com.duiba.galaxy.sdk.api.tools.inner.risk;

import cn.com.duiba.galaxy.sdk.annotation.enums.risk.RiskRuleEngineResult;
import cn.com.duiba.galaxy.sdk.annotation.enums.risk.RiskSceneTypeEnum;
import cn.com.duiba.galaxy.sdk.api.base.ActionContext;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 刘佳辉
 * @since 2023/2/28
 */
public interface RiskControlApi {

    /**
     * 执行风控
     *
     * @param context
     * @param request
     * @param filterBlack
     * @param riskSceneTypeEnum
     * @return
     */
    RiskRuleEngineResult doRiskControl(ActionContext context, HttpServletRequest request, boolean filterBlack, RiskSceneTypeEnum riskSceneTypeEnum);


    /**
     * 记录风控日志
     *
     * @param request
     * @param riskSceneTypeEnum
     * @param jsonExt           风控日志扩展字段
     */
    void doRiskLog(Long projectId,HttpServletRequest request, RiskSceneTypeEnum riskSceneTypeEnum, JSONObject jsonExt);
}
