package cn.com.duiba.galaxy.sdk.component.checkin;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinOptionResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinQueryResult;
import cn.com.duiba.galaxy.sdk.component.checkin.dto.CheckinResult;

import java.util.List;

/**
 * @author qiurenjie
 * @date 2023-01-06 16:46
 */
public abstract class CheckinComponentAction implements BaseComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.CHECKIN;
    }

    /**
     * 查询任务列表
     * 调用 api.doSign()
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "doSign", desc = "签到")
    public abstract CheckinResult doSign(UserRequestApi api);

    /**
     * 查询签到记录-用户维度，非签到维度
     * 请调用 api.query()
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "query", desc = "查询签到记录-用户维度，非签到维度")
    public abstract CheckinQueryResult query(UserRequestApi api);


    /**
     * 查询签到奖品配置
     * 请调用 api.queryOptions()
     *
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryOptions", desc = "查询签到奖品配置")
    public abstract List<CheckinOptionResult> queryOptions(UserRequestApi api);

}
