package cn.com.duiba.galaxy.sdk.component.drawprize;


import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.utils.Conditions;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.component.base.DrawPrizeQueryResult;
import cn.com.duiba.galaxy.sdk.component.base.PrizeResult;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * 抽奖品组件行动默认实现
 * <p>
 * 注意📢：此处需要自行处理并发问题
 *
 * @author fangxiaorun
 * @date 2023/02/02
 */
public class DrawPrizeComponentActionDefault extends DrawPrizeComponentAction {

    private final String componentId;

    public DrawPrizeComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    /**
     * 查询用户参与抽奖的基础信息
     *
     * @param api api
     * @return {@link DrawPrizeQueryResult}
     */
    @Override
    @CustomRequestAction(id = "queryUserInfo", desc = "查询用户参与抽奖的基础信息")
    public DrawPrizeQueryResult queryUserInfo(UserRequestApi api) {
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        return drawPrizeApi.queryUserInfo(componentId, api.getUserId());
    }

    /**
     * 抽奖
     *
     * @param api api
     * @return {@link PrizeResult}
     */
    @Override
    @UserConcurrentLock
    @CustomRequestAction(id = "drawPrize", desc = "抽奖")
    public PrizeResult drawPrize(UserRequestApi api) {
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        return drawPrizeApi.drawPrize(componentId);
    }

    /**
     * 扣积分
     *
     * @param api api
     * @return {@link PrizeResult}
     */
    @Override
    @UserConcurrentLock
    @CustomRequestAction(id = "deductCredits", desc = "扣积分")
    public String deductCredits(UserRequestApi api) {
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        return drawPrizeApi.deductCredits(componentId);
    }

    /**
     * 查询扣积分状态
     *
     * @param api api
     * @return {@link Integer}
     */
    @CustomRequestAction(id = "queryDeductCreditsStatus", desc = "查询扣积分状态")
    public Integer queryDeductCreditsStatus(UserRequestApi api){
        DrawPrizeApi drawPrizeApi = api.getComponentApi().getDrawPrizeApi();
        String ticket = api.getHttpRequest().getParameter("ticket");
        Conditions.expectTrue(StringUtils.isNotBlank(ticket),UnclassifiedStatusEnum.PARAM_ERROR.setDesc("积分门票不能为空") );
        return drawPrizeApi.queryDeductCreditsStatus(ticket);
    };
}
