package cn.com.duiba.galaxy.sdk.component.inviteassist;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.component.BaseComponentAction;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.common.utils.PageList;


/**
 * @author 刘佳辉
 * @since 2022/12/23
 */
public abstract class InviteAssistComponentAction implements BaseComponentAction {

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.INVITEASSIST;
    }


    /**
     * 获取邀请码
     * @param api
     * @return
     */
    @CustomRequestAction(id = "getInviteCode",desc = "获取邀请码")
    public abstract InviteResult getInviteCode(UserRequestApi api);


    @CustomRequestAction(id = "getInviteCodeCoverPeriod",desc = "获取邀请码")
    public abstract InviteResult getInviteCodeCoverPeriod(UserRequestApi api);

    /**
     * 助力
     * @param api
     * @return
     */
    @CustomRequestAction(id = "doAssist",desc = "助力")
    public abstract AssistResult doAssist(UserRequestApi api);



    /**
     * 查询邀请记录
     *  请调用 api.doComplete()
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryInviteRecords",desc = "查询邀请记录")
    public abstract PageList<InviteRecordResult> queryInviteRecords(UserRequestApi api);

    /**
     * 查询助力记录
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryAssistRecords",desc = "查询助力记录")
    public abstract PageList<AssistRecordResult> queryAssistRecords(UserRequestApi api);


    /**
     * 查询未读邀请数量
     * @param api
     * @return
     */
    @CustomRequestAction(id = "queryNewInviteCount",desc = "查询未读邀请数量")
    public abstract int queryNewInviteCount(UserRequestApi api);


}
