package cn.com.duiba.galaxy.sdk.component.inviteassist;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class InviteAssistConfigResult {


    // 新老用户限制 1仅允许新用户 2仅允许老用户  1,2 都允许
    private List<Integer> newOldUserLimit;
    //单用户可助力总次数
    private Integer assistCountLimitType;
    private Integer assistCountLimitValue;
    //单用户可被助力总次数
    private Integer shareCountLimitType;
    private Integer shareCountLimitValue;
    //单个用户被同一用户助力次数
    private Integer bindCountLimitType;
    private Integer bindCountLimitValue;
    // 邀请码有效期 0 永久 1自定义
    private Integer inviteCodeValidityType;
    // 邀请码有效期 0 永久 具体数值就是分钟单位
    private Integer inviteCodeValidity;
    private Boolean awardPrize = false;

    /**
     * 奖品
     */
    private List<InviteAssistPrize> prizes;


    @Data
    public static class InviteAssistPrize {

        /**
         * 邀请人数 起始值
         */
        @NotNull
        private Integer inviteNumStart;

        /**
         * 邀请人数 结束值
         */
        @NotNull
        private Integer inviteNumEnd;

        /**
         * 发奖类型 0 不发奖 1发奖规则 2道具
         */
        @NotNull
        private Integer awardPrizeType;

        /**
         * 发件规则Id
         */
        private String ruleId;


        /**
         * 道具id
         */
        private String spId;


        /**
         * 道具数量
         */
        private Long spNum;

    }

}

