package cn.com.duiba.galaxy.sdk.component.rank.dto;

import lombok.Getter;

/**
 * 奖品类型枚举
 *
 * @author zhangdaqing
 * @date 2022/10/12
 */
@Getter
public enum OptionTypeEnum {
    THANKS(0, "谢谢参与"),
    SP(1, "兑吧道具奖品"),
    PROCUREMENT(2, "采购商品"),

    RECHARGED(3, "充值商品"),
    ;

    private int code;

    private String desc;


    OptionTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static OptionTypeEnum toEnum(int code) {
        for (OptionTypeEnum p : values()) {
            if (p.code == code) {
                return p;
            }
        }
        return null;
    }


}
