/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.api.tools.inner.logger;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuriedPointInfoEnum {
    private static final Logger log = LoggerFactory.getLogger(BuriedPointInfoEnum.class);

    public static EventType getEvenTypeByFiled(String filed) {
        for (EventType value : EventType.values()) {
            if (!value.filed.equals(filed)) continue;
            return value;
        }
        return null;
    }

    public static Map<String, Object> buildBaseFields(Object ... values) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BaseFiled[] fields = BaseFiled.values();
        if (values.length != fields.length) {
            log.error("\u57cb\u70b9\u4fe1\u606f\u6784\u5efa\u9519\u8bef\uff0c\u6570\u636e\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9");
        }
        for (int i = 0; i < fields.length; ++i) {
            map.put(fields[i].filed, values[i]);
        }
        return map;
    }

    public static enum EventType {
        ACTIVITY_ACCESS("activity_access", 501){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"is_from_share", "inviter_id"};
                EventType.dealField(map, files, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("is_from_share"), request.getParameter("inviter_id"));
            }
        }
        ,
        ACTIVITY_JOIN("activity_join", 502){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"is_from_share", "share_code", "consume_ticket"};
                EventType.dealField(map, files, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("is_from_share"), request.getParameter("shareCode"), request.getParameter("consume_ticket"));
            }
        }
        ,
        ACTIVITY_SHARE("activity_share", 505){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"inviter_id"};
                EventType.dealField(map, files, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("inviter_id"));
            }
        }
        ,
        ACTIVITY_INVITE("activity_invite", 503){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"share_code"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("shareCode"));
            }
        }
        ,
        ACTIVITY_HELP("activity_help", 504){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"share_code", "inviter_id", "assist_user_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("shareCode"), request.getParameter("inviterId"), request.getParameter("isInvite"));
            }
        }
        ,
        ACTIVITY_SHARE_PAGE_ACCESS("activity_share_page_access", 506){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"share_code", "assist_user_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("share_code"));
            }
        }
        ,
        ACTIVITY_REMAIN_TIME("activity_remain_time", 156){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"remain_time"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(request.getParameter("remain_time"));
            }
        }
        ,
        ACTIVITY_AWARD_RECEIVE("activity_award_receive", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"prize_record_id", "option_id", "draw_status", "award_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_AWARD("activity_award", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"prize_record_id", "option_id", "send_count", "award_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_CONSUME_CREDITS("activity_consume_credits", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"consume_credits"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_TASK_FINISH("activity_task_finish", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"duiba_task_code", "task_name", "task_type", "is_send_prize", "send_prize_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_TASK_AWARD("activity_task_award", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] field = new String[]{"duiba_task_code", "task_name", "task_type", "send_prize_type", "prize_record_id", "option_id"};
                EventType.dealField(map, field, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_SIGN("activity_sign", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"sign_days", "is_send_prize", "send_prize_type"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_SEND_CODE("activity_send_code", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_BIND_PHONE("activity_bind_phone", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"area_limit"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        }
        ,
        ACTIVITY_AWARD_CLICK("activity_award_click", null){

            @Override
            public Map<String, Object> builder(Object ... values) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(EventType.EVENT_TYPE, this.filed);
                String[] files = new String[]{"join_type", "consume_credits", "sp_id", "sp_quantity"};
                EventType.dealField(map, files, values);
                EventType.dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return this.builder(new Object[0]);
            }
        };

        final String filed;
        final Integer oldCode;
        public static final String EVENT_TYPE = "event_type";
        public static final String CUSTOM_PREF = "custom_";

        private static void dealField(Map<String, Object> map, String[] files, Object[] values) {
            for (int i = 0; i < files.length; ++i) {
                if (values == null || values.length < i) continue;
                map.put(files[i], values[i]);
            }
        }

        public abstract Map<String, Object> builder(Object ... var1);

        public abstract Map<String, Object> builder(HttpServletRequest var1);

        private static void dealCustom(Map<String, Object> map, Object[] values) {
            if (values == null || values.length <= 0) {
                return;
            }
            for (Object value : values) {
                if (!(value instanceof Map)) continue;
                Map custom = (Map)value;
                for (Map.Entry entry : custom.entrySet()) {
                    map.put(CUSTOM_PREF + (String)entry.getKey(), entry.getValue());
                }
            }
        }

        private EventType(String filed, Integer oldCode) {
            this.filed = filed;
            this.oldCode = oldCode;
        }

        public Integer getOldCode() {
            return this.oldCode;
        }

        public static boolean checkExist(String eventType) {
            for (EventType type : EventType.values()) {
                if (!type.filed.equals(eventType)) continue;
                return true;
            }
            return false;
        }

        public static EventType getByFiled(String eventType) {
            for (EventType type : EventType.values()) {
                if (!type.filed.equals(eventType)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum BaseFiled {
        EVENT_TYPE("event_type", String.class),
        LOG_TIME("log_time", String.class),
        LOG_ID("log_id", String.class),
        APP_ID("app_id", Long.class),
        PROJECT_ID("project_id", String.class),
        PROTOTYPE_ID("prototype_id", Long.class),
        PROTOTYPE_TYPE("prototype_type", Long.class),
        USER_TYPE("user_type", Long.class),
        USER_LEVEL("user_level", String.class),
        USER_LABEL("user_label", String.class),
        CLIENT_TYPE("client_type", Long.class),
        CONSUMER_ID("consumer_id", Long.class),
        PARTNER_USER_ID("partner_user_id", Long.class),
        HTTP_METHOD("http_method", Long.class),
        IP("ip", String.class),
        IP_PROVINCE("ip_province", String.class),
        IP_CITY("ip_city", String.class),
        REFERER("referer", String.class),
        URL_PATH("url_path", String.class),
        URL_QUERY("url_query", String.class),
        USER_AGENT("user_agent", String.class),
        USER_AGENT_OS("user_agent_os", String.class),
        USER_AGENT_VERSION("user_agent_version", String.class),
        USER_AGENT_MODEL("user_agent_model", String.class),
        CHANNEL_SOURCE("channel_source", String.class),
        CURRENT_CREDITS("current_credits", Long.class),
        PLATFORM_TYPR("platform_type", Long.class);

        final String filed;
        final Class<?> type;

        private BaseFiled(String filed, Class<?> type) {
            this.filed = filed;
            this.type = type;
        }
    }
}

