/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.bindphone;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.message.BizError;
import cn.com.duiba.galaxy.common.utils.Conditions;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.EnableRiskControl;
import cn.com.duiba.galaxy.sdk.component.ComponentTypeEnum;
import cn.com.duiba.galaxy.sdk.component.bindphone.BindPhoneApi;
import cn.com.duiba.galaxy.sdk.component.bindphone.BindPhoneComponent;
import cn.com.duiba.galaxy.sdk.component.bindphone.param.BindPhoneParam;
import cn.com.duiba.galaxy.sdk.component.bindphone.param.SendSmsCodeParam;
import cn.com.duiba.galaxy.sdk.component.bindphone.vo.BindPhoneResult;
import cn.com.duiba.galaxy.sdk.component.bindphone.vo.SendSmsCodeResult;
import cn.com.duiba.galaxy.sdk.message.UnclassifiedStatusEnum;
import cn.com.duiba.galaxy.sdk.util.UserLock;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindPhoneComponentDefault
extends BindPhoneComponent {
    private static final Logger log = LoggerFactory.getLogger(BindPhoneComponentDefault.class);
    private final String componentId;

    public BindPhoneComponentDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @EnableRiskControl
    @CustomRequestAction(id="sendSmsCode", desc="\u7ed1\u5b9a\u624b\u673a\u53f7\u7ec4\u4ef6-\u53d1\u9001\u9a8c\u8bc1\u7801")
    public SendSmsCodeResult sendSmsCode(UserRequestApi context, BindPhoneApi api) {
        String phoneNumber = context.getHttpRequest().getParameter("phoneNumber");
        Conditions.expectFalse((boolean)StringUtils.isBlank((CharSequence)phoneNumber), (BizError)UnclassifiedStatusEnum.PARAM_ERROR.setDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7"));
        String groupName = context.getHttpRequest().getParameter("groupName");
        String slideValidate = context.getHttpRequest().getParameter("slideValidate");
        String expireTime = context.getHttpRequest().getParameter("expireTime");
        api.checkToken(context);
        UserLock lock = api.getUserLock(context, 3);
        SendSmsCodeParam param = new SendSmsCodeParam();
        try {
            param.setPlaywayId(this.componentId);
            param.setGroupName(groupName);
            param.setPhoneNumber(phoneNumber);
            param.setCodeLength(6);
            param.setValidate(slideValidate);
            param.setSlideValidate(slideValidate);
            if (StringUtils.isNotBlank((CharSequence)expireTime) && NumberUtils.isNumeric((String)expireTime) && Integer.parseInt(expireTime) > 0 && Integer.parseInt(expireTime) < 30) {
                param.setExpireTime(Integer.parseInt(expireTime));
            }
            SendSmsCodeResult sendSmsCodeResult = (SendSmsCodeResult)BeanUtils.copy((Object)api.sendSmsCode(param), SendSmsCodeResult.class);
            return sendSmsCodeResult;
        }
        catch (BizRuntimeException e) {
            log.warn("\u7ec4\u4ef6LOGGER \u624b\u673a\u53f7\u7ed1\u5b9a\u7ec4\u4ef6 \u7ed1\u5b9a\u624b\u673a\u53f7Action\u5f02\u5e38-projectId={}, playwayId={}, actionId={} userId={}, param={}", new Object[]{api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString((Object)param), e});
            throw new BizRuntimeException(e.getMessage(), e.getCode(), false);
        }
        catch (Exception e) {
            log.warn("\u7ec4\u4ef6LOGGER \u624b\u673a\u53f7\u7ed1\u5b9a\u7ec4\u4ef6 \u53d1\u9a8c\u8bc1\u7801Action\u5f02\u5e38-projectId={}, playwayId={}, actionId={} userId={}, param={}", new Object[]{api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString((Object)param), e});
            throw new BizRuntimeException(UnclassifiedStatusEnum.SYSTEM_ERROR.setDesc("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), false);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @EnableRiskControl
    @CustomRequestAction(id="bindPhone", desc="\u7ed1\u5b9a\u624b\u673a\u53f7\u7ec4\u4ef6-\u7ed1\u5b9a\u624b\u673a\u53f7")
    public BindPhoneResult bindPhone(UserRequestApi context, BindPhoneApi api) {
        String phoneNumber = context.getHttpRequest().getParameter("phoneNumber");
        Conditions.expectFalse((boolean)StringUtils.isBlank((CharSequence)phoneNumber), (BizError)UnclassifiedStatusEnum.PARAM_ERROR.setDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7"));
        String smsCode = context.getHttpRequest().getParameter("smsCode");
        Conditions.expectFalse((boolean)StringUtils.isBlank((CharSequence)smsCode), (BizError)UnclassifiedStatusEnum.PARAM_ERROR.setDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u77ed\u4fe1\u9a8c\u8bc1\u7801"));
        String groupName = context.getHttpRequest().getParameter("groupName");
        String recordExtra = context.getHttpRequest().getParameter("recordExtra");
        api.checkToken(context);
        UserLock lock = api.getUserLock(context, 3);
        BindPhoneParam param = new BindPhoneParam();
        try {
            param.setPlaywayId(api.getActionContext().getPlaywayId());
            param.setGroupName(groupName);
            param.setPhoneNumber(phoneNumber);
            param.setSmsCode(smsCode);
            param.setRecordExtra(recordExtra);
            boolean bo = api.bindPhone(param);
            BindPhoneResult result = new BindPhoneResult();
            result.setBindResult(bo);
            BindPhoneResult bindPhoneResult = result;
            return bindPhoneResult;
        }
        catch (BizRuntimeException e) {
            log.warn("\u7ec4\u4ef6LOGGER \u624b\u673a\u53f7\u7ed1\u5b9a\u7ec4\u4ef6 \u7ed1\u5b9a\u624b\u673a\u53f7Action\u5f02\u5e38-projectId={}, playwayId={}, actionId={} userId={}, param={}", new Object[]{api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString((Object)param), e});
            throw new BizRuntimeException(e.getMessage(), e.getCode(), false);
        }
        catch (Exception e) {
            log.warn("\u7ec4\u4ef6LOGGER \u624b\u673a\u53f7\u7ed1\u5b9a\u7ec4\u4ef6 \u7ed1\u5b9a\u624b\u673a\u53f7Action\u5f02\u5e38-projectId={}, playwayId={}, actionId={} userId={}, param={}", new Object[]{api.getActionContext().getProjectId(), api.getActionContext().getPlaywayId(), api.getActionContext().getActionId(), context.getUserId(), JSONObject.toJSONString((Object)param), e});
            throw new BizRuntimeException(UnclassifiedStatusEnum.SYSTEM_ERROR.setDesc("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"), false);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ComponentTypeEnum getType() {
        return ComponentTypeEnum.BINDPHONE;
    }
}

