/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.galaxy.sdk.component.task;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.annotation.ProjectCycleCheck;
import cn.com.duiba.galaxy.sdk.annotation.UserConcurrentLock;
import cn.com.duiba.galaxy.sdk.api.prize.inner.StrategyResult;
import cn.com.duiba.galaxy.sdk.component.task.TaskApi;
import cn.com.duiba.galaxy.sdk.component.task.TaskComponentAction;
import cn.com.duiba.galaxy.sdk.component.task.TaskQueryResult;
import cn.com.duiba.galaxy.sdk.component.task.TaskResult;

public class TaskComponentActionDefault
extends TaskComponentAction {
    private final String componentId;

    public TaskComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    @Override
    @CustomRequestAction(id="queryTasks", desc="\u67e5\u8be2\u4efb\u52a1")
    public TaskQueryResult queryTasks(UserRequestApi api) {
        TaskApi taskApi = api.getComponentApi().getTaskApi();
        return taskApi.queryTasks(this.componentId, api.getUserId());
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id="doCompleted", desc="\u5b8c\u6210\u4efb\u52a1")
    public TaskResult doCompleted(UserRequestApi api) {
        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode");
        return taskApi.doCompletedForCode(this.componentId, api.getUserId(), taskCode);
    }

    @Override
    @UserConcurrentLock
    @ProjectCycleCheck
    @CustomRequestAction(id="doCompletedSendPrize", desc="\u5b8c\u6210\u4efb\u52a1\u81ea\u52a8\u53d1\u5956")
    public TaskResult doCompletedSendPrize(UserRequestApi api) {
        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode", "\u4efb\u52a1code\u4e0d\u80fd\u7a7a");
        return taskApi.doCompletedAndSendPrizeForCode(this.componentId, api.getUserId(), taskCode);
    }

    @Override
    @ProjectCycleCheck
    @CustomRequestAction(id="sendPrize", desc="\u9886\u5956")
    public StrategyResult sendPrize(UserRequestApi api) {
        TaskApi taskApi = api.getComponentApi().getTaskApi();
        String taskCode = api.getStringParameterCheckBlank("taskCode", "\u4efb\u52a1code\u4e0d\u80fd\u7a7a");
        String prizePendingCode = api.getStringParameterCheckBlank("prizePendingCode", "\u9886\u5956\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return taskApi.sendPrizeForCode(this.componentId, api.getUserId(), taskCode, prizePendingCode);
    }
}

