package cn.com.duiba.galaxy.sdk.annotation;


import cn.com.duiba.galaxy.sdk.annotation.enums.risk.RiskSceneTypeEnum;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标识是否走风控
 */
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Target({ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface EnableRiskControl {

    /**
     * 风控场景
     */
    RiskSceneTypeEnum value() default RiskSceneTypeEnum.ACTIVITY;

    /**
     * 默认不拦截
     * true 如果是黑名单用户直接拦截
     * false 不拦截黑名单用户
     *
     * @return 是否拦截黑名单用户
     */
    boolean filterBlack() default false;
}
