package cn.com.duiba.galaxy.sdk.annotation.enums.risk;

import lombok.Getter;

@Getter
public enum RiskSceneTypeEnum {


    DEFAULT(0, "默认(不走风控)"),

    ACTIVITY(64, "活动参与"),
    WITHDRAW(65, "提现"),
    SEND_PRIZE(71, "发奖"),
    EXCHANGE(76, "兑换"),
    INVITE(77, "助力"),

    VISIT(92, "访问"),
    VISIT_TIME(93, "访问时长"),
    CLICK(94, "按钮点击"),

    ;

    RiskSceneTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;


}
