package cn.com.duiba.galaxy.sdk.api.http.inner;

import cn.com.duiba.galaxy.common.base.JsonResult;
import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.common.exception.ErrorCode;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.SocketTimeoutException;

/**
 * 对异步请求HttpAsyncClientHelper做解耦处理，分离出业务相关、具有平台特性的代码
 * 由于异步线程响应需和同步响线程应统一
 * @author jiaxz
 * @since 2022-01-04
 */
public class AsyncResultUtil {
    private static final Logger log = LoggerFactory.getLogger(AsyncResultUtil.class);

    //封装处理接口返回数据，参考ProjectController.doAction
    public static String handleResult(Object result, Exception e) {
        JsonResult errMsg = JsonResult.fail("unknow");
        try {
            //如果没有异常，直接封装
            if (e == null) {
                JsonResult ret = JsonResult.success(result);
                return JSONObject.toJSONString(ret, SerializerFeature.WriteMapNullValue);
            }


            //业务异常
            if (e instanceof cn.com.duiba.galaxy.common.exception.BizRuntimeException) {
                errMsg = JsonResult.fail(((BizRuntimeException)e).getCode(), e.getMessage());
                return JSONObject.toJSONString(errMsg, SerializerFeature.WriteMapNullValue);
                //系统异常
            }else if (e instanceof SocketTimeoutException) {
                //超时
                errMsg = JsonResult.fail(ErrorCode.ERR_100064.toString(), ErrorCode.ERR_100064_MSG);
                return JSONObject.toJSONString(errMsg, SerializerFeature.WriteMapNullValue);
                //系统异常
            }else {
                errMsg = JsonResult.fail(ErrorCode.ERR_10000, ErrorCode.ERR_10000_MSG);
                return JSONObject.toJSONString(errMsg, SerializerFeature.WriteMapNullValue);
            }
        }catch (Exception ex){
            log.error("系统异常",ex);
            errMsg = JsonResult.fail(ErrorCode.ERR_10000, ErrorCode.ERR_10000_MSG);
            return JSONObject.toJSONString(errMsg, SerializerFeature.WriteMapNullValue);
        }
    }

}
