package cn.com.duiba.galaxy.sdk.component.drawprize.dto;

import cn.com.duiba.galaxy.sdk.component.base.BaseResult;
import cn.com.duiba.galaxy.sdk.component.drawprize.enums.OtherJoinTypeEnum;
import lombok.Getter;
import lombok.Setter;

/**
 * 参与查询结果
 *
 * @author fangxiaorun
 * @date 2023/02/06
 */
@Getter
@Setter
public class ParticipateQueryResult extends BaseResult {
    /**
     * 其他参与类型
     * @see OtherJoinTypeEnum
     */
    private Integer configJoinType;

    /**
     * 配置其他参与道具ID
     */
    private String configJoinSpId;

    /**
     * 配置其他参与道具名称
     */
    private String configJoinSpName;

    /**
     * 配置其他参与值
     * 当joinType=2时，表示积分值
     * 当joinType=3时，表示道具个数
     */
    private Integer configJoinValue;

    /**
     * 免费配置次数
     */
    private Integer configFreeSize;

    /**
     * 其他配置次数
     */
    private Integer configLimitSize;

    /**
     * 增加的次数
     */
    private Integer addTotalSize;

    /**
     * 可用的积分或道具数
     */
    private Long myCreditsOrSpValue;

    /**
     * 参与次数
     */
    private Integer joinCount;

    /**
     * 免费剩余次数
     */
    private Integer freeLeftCount;

    /**
     * 其他剩余次数（null = 无次数限制）
     */
    private Integer otherLeftCount;

    /**
     * 增加剩余次数
     */
    private Integer addLeftCount;

    /**
     * 总剩余次数（null = 无次数限制）
     */
    private Integer leftCount;
}
