package cn.com.duiba.galaxy.sdk.component.inviteassist;

import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.common.utils.PageList;

import java.util.List;

public interface InviteAssistApi extends UserRequestApi {

    /**
     * 查询组件配置信息
     */
    InviteAssistConfigResult getComponentConfig(String componentId);

    /**
     * 获取邀请码
     * <p> 邀请码生产规则:
     * 1. 6位,数字或字母.
     * 2. ⚠️ 同用户同玩法下,是同一个邀请码.
     * </p>
     *
     * @param componentId 玩法ID
     * @return
     */
    InviteResult getInviteCode(String componentId);


    /**
     * 获取邀请码且重置周期
     *
     * @param componentId
     * @return
     */
    InviteResult getInviteCodeCoverPeriod(String componentId);

    /**
     * 根据邀请码获取用户Id
     *
     * @param inviteCode 邀请码
     * @return
     */
    Long getUserIdByInviteCode(String inviteCode);

    /**
     * 助力
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * <p>1. 助力条件判断
     * <p>2. 接受邀请
     * <p>3. 给分享者发奖
     *
     * @param componentId 玩法ID
     * @param inviteCode  邀请码
     * @param extra       扩展值
     * @return
     */
    AssistResult doAssist(String componentId, String inviteCode, String extra);

    /**
     * 助力
     * ⚠️ 接口内部不作单用户高刷处理，由业务方决定
     *
     * <p>1. 助力条件判断
     * <p>2. 接受邀请
     * <p>3. 给分享者发奖
     *
     * @param componentId 玩法ID
     * @param inviteCode  邀请码
     * @param ruleId      发奖规则：默认为空，为空时使用组件配置的发奖规则，不为空时使用ruleId对应的发奖规则，⚠️覆盖组件配置的发奖规则
     *
     * @param extra       扩展值
     * @return
     */
    AssistResult doAssist(String componentId, String inviteCode, String ruleId, String extra);

    /**
     * 查询新邀请数量
     * <p>
     * 调用一下方法会清空新助力用户
     * queryNewInviteCount,
     * queryNewInviteRecords,
     * queryTodayInviteRecords,
     * queryInviteRecords
     * </p>
     *
     * @param componentId 玩法ID
     * @param userId      用户ID
     * @return
     */
    int queryNewInviteCount(String componentId, Long userId);

    /**
     * 查询所有邀请数量
     *
     * @param componentId          玩法ID
     * @param userId               用户ID
     * @param distinctAssistUserId 是否去重助力者, 默认:false
     *                             true=去重
     *                             false=不去重
     * @return
     */
    int queryAllInviteCount(String componentId, Long userId, Boolean distinctAssistUserId);

    /**
     * 查询今日的邀请记录
     * <p>时间倒序
     * <p>返回最近500条记录
     * <p>清空新助力用户
     *
     * @param componentId 玩法ID
     * @param userId      用户ID
     * @return
     */
    List<InviteRecordResult> queryTodayInviteRecords(String componentId, Long userId);

    /**
     * 查询新邀请记录
     * <p>时间倒序
     * <p>返回最近200条记录
     * <p>清空新助力用户
     *
     * @param componentId 玩法ID
     * @param userId      用户ID
     * @return
     */
    List<InviteRecordResult> queryNewInviteRecords(String componentId, Long userId);

    /**
     * 查询邀请记录
     * <p>时间倒序
     * <p>清空新助力用户
     *
     * @param param 查询参数
     *              ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<InviteRecordResult> queryInviteRecords(InviteAssistQueryParam param);

    /**
     * 查询今日的助力记录
     * <p>时间倒序
     * <p>返回最近500条记录
     *
     * @param componentId 玩法ID
     * @param userId      用户ID
     * @return
     */
    List<AssistRecordResult> queryTodayAssistRecords(String componentId, Long userId);

    /**
     * 查询助力记录
     * <p>时间倒序
     *
     * @param param 查询参数
     *              ⚠️ pageNum 当前页,从1开始
     * @return
     */
    PageList<AssistRecordResult> queryAssistRecords(InviteAssistQueryParam param);

    /**
     * 查询所有助力数量
     *
     * @param componentId         玩法ID
     * @param userId              用户ID
     * @param distinctShareUserId 是否去重分享者, 默认:false
     *                            true=去重
     *                            false=不去重
     * @return
     */
    long queryAllAssistCount(String componentId, Long userId, Boolean distinctShareUserId);

}
