package cn.com.duiba.galaxy.sdk.component.rank;

import cn.com.duiba.galaxy.common.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.PlatformSdkErrorEnum;
import cn.com.duiba.galaxy.sdk.UserRequestApi;
import cn.com.duiba.galaxy.sdk.annotation.CustomRequestAction;
import cn.com.duiba.galaxy.sdk.api.user.inner.ConsumerExtra;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author jiaxz
 * @since 2023-01-18
 */
public class RankComponentActionDefault extends RankComponentAction {

    private final String componentId;

    public RankComponentActionDefault(String componentId) {
        this.componentId = componentId;
    }

    /**
     * 查询排行榜信息
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryRankInfo", desc = "查询排行榜信息")
    public RankConfigVo queryRankInfo(UserRequestApi api) {
        // phaseType   0 获取当前期次 -1 获取上一期次
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");

        RankApi rankApi = api.getComponentApi().getRankApi();
        String type = rankApi.getHistoryType(componentId,-phaseType);

        return rankApi.queryArchive(componentId,type);
    }

    /**
     * 查询排行榜
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryRanking", desc = "查询排行榜")
    public RankingVo queryRanking(UserRequestApi api) {
        RankApi rankApi = api.getComponentApi().getRankApi();
        Integer topN = api.getIntegerParameterCheckNull("topN");
        if (topN == null || topN > 500) {
            throw new BizRuntimeException(PlatformSdkErrorEnum.PARAM_ERROR);
        }
        // phaseType   0 获取当前期次 -1 获取上一期次 -2 获取上上期 ..
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");

        String type = rankApi.getHistoryType(componentId,-phaseType);
        if(type==null){
            // 无期次情况
            return null;
        }
        List<Ranking> topRankingN  = rankApi.getRankingTopN(componentId, type,topN);;
        Ranking myRanking = rankApi.getHistoryRankInfo(componentId, api.getUserId(),type);
        Integer myRankNum = rankApi.getRanking(componentId, api.getUserId(), type);

        // 排行榜数据
        RankingVo rankingVo = new RankingVo();
        List<RankingVo.RankingInfo> list = new ArrayList<>();

        // 我的排行榜信息
        if (myRanking == null) {
            myRanking = new Ranking();
            myRanking.setUserId(api.getUserId());
        }
        topRankingN.add(0, myRanking);

        // 是否有上有下
        String previousType = rankApi.getPreviousType(componentId);
        rankingVo.setHasPreFlag(previousType != null);
        rankingVo.setHasNextFlag(!rankApi.queryLastPhaseAction(componentId,type));

        if (topRankingN.size()<=1) {
            // 有期次，无参与人员情况
            return rankingVo;
        }

        // 处理排行榜数据
        List<Long> userIds = topRankingN.stream().map(Ranking::getUserId).collect(Collectors.toList());
        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(userIds);
        Map<Long, ConsumerExtra> consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));

        for (int i = 0; i < topRankingN.size(); i++) {
            Ranking ranking = topRankingN.get(i);
            RankingVo.RankingInfo rankingInfo = new RankingVo.RankingInfo();
            rankingInfo.setIndex(i);
            rankingInfo.setScore(ranking.getMaxScore());
            rankingInfo.setUserId(ranking.getUserId());
            ConsumerExtra consumerExtra = consumerMap.get(ranking.getUserId());
            if (consumerExtra != null) {
                rankingInfo.setAvatar(consumerExtra.getAvatar());
                rankingInfo.setNickname(consumerExtra.getNickname());
            }
            list.add(rankingInfo);
        }
        RankingVo.RankingInfo rankingInfo = list.get(0);
        list.remove(0);
        rankingInfo.setIndex(myRankNum);
        rankingVo.setRankingInfos(list);
        rankingVo.setMyRanking(rankingInfo);

        return rankingVo;
    }


    /**
     * 查询当前用户排行榜信息
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryUserRanking", desc = "查询当前用户排行榜信息")
    public RankingVo.RankingInfo queryUserRanking(UserRequestApi api) {
        RankApi rankApi = api.getComponentApi().getRankApi();
        // phaseType   0 获取当前期次 -1 获取上一期次
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        if(phaseType>0){
            throw new BizRuntimeException(PlatformSdkErrorEnum.PARAM_ERROR);
        }
        String type =rankApi.getHistoryType(componentId,-phaseType);

        Integer  myRank = rankApi.getRanking(componentId, api.getUserId(), type);
        Ranking  myRanking = rankApi.getHistoryRankInfo(componentId, api.getUserId(), type);


        if (myRanking == null) {
            return null;
        }

        List<ConsumerExtra> consumerExtras = api.getConsumerApi().listConsumerExtraByConsumerIds(Collections.singletonList(api.getUserId()));
        Map<Long, ConsumerExtra> consumerMap = consumerExtras.stream().collect(Collectors.toMap(ConsumerExtra::getConsumerId, Function.identity()));

        RankingVo.RankingInfo rankingVo = new RankingVo.RankingInfo();
        rankingVo.setIndex(myRank);
        rankingVo.setScore(myRanking.getMaxScore());
        rankingVo.setUserId(api.getUserId());
        ConsumerExtra consumerExtra = consumerMap.get(api.getUserId());
        if (consumerExtra != null) {
            rankingVo.setAvatar(consumerExtra.getAvatar());
            rankingVo.setNickname(consumerExtra.getNickname());
        }

        return rankingVo;
    }


    /**
     * 查询当前排行榜是否最后一期
     *
     * @param api
     * @return
     */
    @Override
    @CustomRequestAction(id = "queryLastPhaseAction", desc = "查询当前排行榜是否最后一期")
    public Boolean queryLastPhaseAction(UserRequestApi api) {
        String type = api.getComponentApi().getRankApi().getCurrentType(componentId);
        return api.getComponentApi().getRankApi().queryLastPhaseAction(componentId,type);
    }

    @Override
    @CustomRequestAction(id = "queryPrizeAction", desc = "查询中奖信息")
    public RankPeriodPrizeVo queryPrizeAction(UserRequestApi api) {
        // phaseType   0 获取当前期次 -1 获取上一期次 ...
        Integer phaseType = api.getIntegerParameterCheckNull("phaseType");
        RankApi rankApi = api.getComponentApi().getRankApi();
        RankPeriodPrizeVo rankConfigVo = null;
        String type = rankApi.getHistoryType(componentId,-phaseType);
        if (type == null) {
            return null;
        }

        rankConfigVo = rankApi.queryPrizeAction(componentId, type);

        return rankConfigVo;
    }
}
