package cn.com.duiba.galaxy.sdk.component.rank;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @author 刘佳辉
 * @since 2023/2/14
 */
@Data
public class RankConfigVo {

    /**
     * 排行榜开始时间
     */
    private Date rankStartTime;

    /**
     * 排行榜结束时间
     */
    private Date rankEndTime;

    /**
     * 排行榜期次
     */
    private String rankingType;

    /**
     * 期次开始时间
     */
    private Date startTime;

    /**
     * 期次结束时间
     */
    private Date endTime;

    /**
     * 开奖时间
     */
    private Date opTime;


    /**
     * 发奖开关是否开启
     */
    private Boolean prizeSwitch;

    /**
     * 开奖状态，注意
     * 部分失败也会记录为失败，不代表所有用户都失败
     *  (0,"未开奖"),
     *  (1,"开奖中"),
     *  (2,"已开奖"),
     *  (3,"开奖失败"),
     */
    private Integer opStatus;

    /**
     * 配置奖品
     */
    private List<RankPrizeVo> configPrize;



}
