package cn.com.duiba.galaxy.sdk.utils;

import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;
import cn.com.duiba.galaxy.sdk.message.BizError;

/**
 * 条件断言工具
 *
 * @author fangxiaorun
 * @date 2022/09/29
 */
public class Conditions {
    /**
     * 期望为假
     *
     * @param expression 表达式
     * @param bizError   业务错误
     */
    public static void expectFalse(boolean expression, BizError bizError) {
        if (expression) {
            throw new BizRuntimeException(bizError, false);
        }
    }

    /**
     * 期望所有为真
     *
     * @param bizError    业务错误
     * @param expressions 表达式
     */
    public static void expectAllTrue(BizError bizError, boolean... expressions) {
        for (boolean b : expressions) {
            if (!b) {
                throw new BizRuntimeException(bizError, false);
            }
        }
    }

    /**
     * 期望为真
     *
     * @param expression 表达式
     * @param bizError   业务错误
     */
    public static void expectTrue(boolean expression, BizError bizError) {
        if (!expression) {
            throw new BizRuntimeException(bizError, false);
        }
    }

    /**
     * 期望不为空
     *
     * @param reference 目标对象
     * @param bizError  业务错误
     * @return {@link T}
     */
    public static <T> T expectNotNull(T reference, BizError bizError) {
        if (reference == null) {
            throw new BizRuntimeException(bizError, false);
        } else {
            return reference;
        }
    }

}
