package cn.com.duiba.galaxy.sdk.apiextra;


import cn.com.duiba.galaxy.sdk.SignApi;
import org.springframework.web.client.RestTemplate;

/**
 * 定时任务作用域下的API
 *
 * @author xuhengfei
 */
public interface TimerApi {

    /**
     * 获取redisapi
     *
     * @return {@link RedisApi}
     */
    RedisApi getRedisApi();

    /**
     * 获取应用id
     *
     * @return {@link Long}
     */
    Long getAppId();

    /**
     * 获取项目id
     *
     * @return {@link Long}
     */
    Long getProjectId();

    /**
     * RestTemplate
     *
     * @return {@link RestTemplate}
     */
    RestTemplate getLoadBalancedRestTemplate();

    /**
     * 获取签名api
     *
     * @return {@link SignApi}
     */
    SignApi getSignApi();
}
