package cn.com.duiba.galaxy.sdk.emums;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author zhangdaqing
 * @Date 2022/11/3 20:01
 **/
public enum StrategyTypeEnum implements Serializable {

    MUST("ru_must", "百分百中奖"),
    RANDOM("ru_random", "概率中奖"),
    ;

    private String ruId;
    private String desc;

    StrategyTypeEnum(String ruId, String desc) {
        this.ruId = ruId;
        this.desc = desc;
    }

    public static StrategyTypeEnum getStrategyTypeEnumByRuId(String ruId) {
        Optional<StrategyTypeEnum> first = Arrays.stream(values()).filter(u -> Objects.equals(u.getRuId(), ruId)).findFirst();
        return first.orElse(null);
    }


    public String getRuId() {
        return ruId;
    }

    public String getDesc() {
        return desc;
    }
}
