package cn.com.duiba.galaxy.sdk.exception;


import cn.com.duiba.galaxy.sdk.message.BizError;

/**
 * 自定义运行时异常
 *
 * @author houwen
 * @date 2022/09/28
 */
public class BizRuntimeException extends RuntimeException {
    /**
     * 错误码
     */
    private String code;

    /**
     * 是否打印告警日志，默认打印
     */
    private Boolean outWarnLog = true;

    public BizRuntimeException(BizError error) {
        super(error.getDesc());
        this.code = error.getCode();
    }
    public BizRuntimeException(String message) {
        super(message);
    }

    public BizRuntimeException(Exception e) {
        super(e.getMessage());
    }

    public BizRuntimeException(String message, boolean outWarnLog) {
        super(message);
        this.outWarnLog = outWarnLog;
    }


    public BizRuntimeException(BizError error, boolean outWarnLog) {
        super(error.getDesc());
        this.code = error.getCode();
        this.outWarnLog = outWarnLog;
    }

    public BizRuntimeException(BizError error, Throwable cause) {
        super(error.getDesc(), cause);
        this.code = error.getCode();
    }

    public BizRuntimeException(BizError error, Throwable cause, boolean outWarnLog) {
        super(error.getDesc(), cause);
        this.code = error.getCode();
        this.outWarnLog = outWarnLog;
    }

    public String getCode() {
        return code;
    }

    public boolean isOutWarnLog() {
        return outWarnLog;
    }
}
