package cn.com.duiba.galaxy.sdk.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 埋点信息枚举
 * <href>http://cf.dui88.com/pages/viewpage.action?pageId=163754247</>
 *
 * @author 刘佳辉
 * @since 2022/10/25
 */
public class BuriedPointInfoEnum {


    private static final Logger log = LoggerFactory.getLogger(BuriedPointInfoEnum.class);

    public static EventType getEvenTypeByFiled(String filed){
        for (EventType value : EventType.values()) {
            if(value.filed.equals(filed)){
                return value;
            }
        }
        return null;
    }

    /**
     * 构建基础参数（顺序匹配）
     *
     * @param values
     * @return
     */
    public static Map<String, Object> buildBaseFields(Object... values) {

        HashMap<String, Object> map = new HashMap<>();
        BaseFiled[] fields = BaseFiled.values();
        if (values.length != fields.length) {
            log.error("埋点信息构建错误，数据不匹配，请核对");
        }
        for (int i = 0; i < fields.length; i++) {
            map.put(fields[i].filed, values[i]);
        }
        return map;
    }

    /**
     * 基础必填字段
     */
    public enum BaseFiled {

        /**
         * 事件类型
         * 事件的英文名称
         */
        EVENT_TYPE("event_type", String.class),
        /**
         * 打印日志时间
         * 打印日志时的时间，格式：yyyy-MM-dd HH:mm:ss
         */
        LOG_TIME("log_time", String.class),
        /**
         * 日志id
         * UUID，32位。每条日志，都有自己的唯一标识，方便统计排查
         */
        LOG_ID("log_id", String.class),


        APP_ID("app_id", Long.class),

        /**
         * 活动id
         */
        PROJECT_ID("project_id", String.class),

        /**
         * 原型ID
         */
        PROTOTYPE_ID("prototype_id", Long.class),

        /**
         * 原型类型 1定制,2模板
         */
        PROTOTYPE_TYPE("prototype_type", Long.class),

        /**
         * 1、新用户
         * 2、老用户
         * 3、全部用户
         */
        USER_TYPE("user_type", Long.class),

        /**
         * 用户等级
         */
        USER_LEVEL("user_level", String.class),

        /**
         * 根据客户传的标签
         */
        USER_LABEL("user_label", String.class),

        /**
         * 访问端口
         * 1、微信
         * 2、小程序
         * 3、app
         */
        CLIENT_TYPE("client_type", Long.class),

        /**
         * 用户ID
         */
        CONSUMER_ID("consumer_id", Long.class),


        /**
         * 用户id uid
         */
        PARTNER_USER_ID("partner_user_id", Long.class),

        /**
         * 请求类型
         */
        HTTP_METHOD("http_method", Long.class),

        /**
         * ip
         */
        IP("ip", String.class),

        IP_PROVINCE("ip_province", String.class),

        IP_CITY("ip_city", String.class),

        /**
         * 来源地址
         */
        REFERER("referer", String.class),

        /**
         * 访问路径
         */
        URL_PATH("url_path", String.class),

        /**
         * 请求参数
         */
        URL_QUERY("url_query", String.class),

        /**
         * 代理信息
         * <p>
         * ---user_agent1<br/>
         * Mozilla/5.0 (Linux; Android 7.0; MHA-AL00 Build/HUAWEIMHA-AL00; wv)
         * AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/77.0.3865.120
         * MQQBrowser/6.2 TBS/045709 Mobile Safari/537.36
         * MMWEBID/9943 MicroMessenger/7.0.17.1720(0x27001135) Process/tools WeChat/arm64 NetType/WIFI Language/zh_CN ABI/arm64
         * <p>
         * ---user_agent2<br/>
         * Mozilla/5.0 (Linux; Android 12; V2055A Build/SP1A.210812.003; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/91.0.4472.114 Mobile Safari/537.36/lenovoofficialapp/16501169228903816_10216926194/newversion/versioncode-1000086/
         */
        USER_AGENT("user_agent", String.class),

        USER_AGENT_OS("user_agent_os", String.class),

        USER_AGENT_VERSION("user_agent_version", String.class),

        /**
         * 设备型号
         */
        USER_AGENT_MODEL("user_agent_model", String.class),

        /**
         * 渠道名称（都字符串）
         */
        CHANNEL_SOURCE("channel_source", String.class),

        /**
         * 当前携带积分
         */
        CURRENT_CREDITS("current_credits", Long.class),


        /**
         * 服务标识，活动平台是1 固定
         */
        PLATFORM_TYPR("platform_type", Long.class),


        ;
        final String filed;
        final Class<?> type;

        BaseFiled(String filed, Class<?> type) {
            this.filed = filed;
            this.type = type;
        }
    }


    /**
     * 事件类型
     */
    public enum EventType {

        /**
         * 活动访问
         */
        ACTIVITY_ACCESS("activity_access", 501) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                //是否通过分享出去的链接进入 1：是
                String[] files={"is_from_share","inviter_id"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("is_from_share"), request.getParameter("inviter_id"));
            }
        },
        /**
         * 活动参与
         */
        ACTIVITY_JOIN("activity_join", 502) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"is_from_share","share_code","consume_ticket"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("is_from_share"), request.getParameter("shareCode"), request.getParameter("consume_ticket"));
            }
        },
        /**
         * 分享
         */
        ACTIVITY_SHARE("activity_share", 505) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"inviter_id"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("inviter_id"));
            }
        },

        /**
         * 活动邀请
         */
        ACTIVITY_INVITE("activity_invite", 503) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"share_code"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("shareCode"));
            }
        },

        /**
         * 活动助力
         */
        ACTIVITY_HELP("activity_help", 504) {
            /**
             *
             * @param values 分享码,邀请者id,是否来源于邀请,自定义map
             * @return
             */
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"share_code","inviter_id","is_invite"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("shareCode"), request.getParameter("inviterId"), request.getParameter("isInvite"));
            }
        },

        /**
         * 分享访问
         */
        ACTIVITY_SHARE_PAGE_ACCESS("activity_share_page_access", 506) {
            /**
             *
             * @param values 分享码,自定义map
             * @return
             */
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"share_code"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }

                dealCustom(map, values);
                return map;
            }


            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("share_code"));
            }
        },
        /**
         * 访问时长
         */
        ACTIVITY_REMAIN_TIME("activity_remain_time", 156) {
            /**
             *
             * @param values 停留时长，自定义map
             * @return
             */
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"remain_time"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder(request.getParameter("remain_time"));
            }
        },


        /**
         * 活动领奖
         */
        ACTIVITY_AWARD_RECEIVE("activity_award_receive", null) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                // 999_511 分表id和主键id
                String[] files={"prize_record_id","option_id","draw_status"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder();
            }
        },

        /**
         * 活动中奖
         */
        ACTIVITY_AWARD("activity_award", null) {
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"prize_record_id","option_id"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder();
            }
        },

        /**
         * 活动消耗积分
         */
        ACTIVITY_CONSUME_CREDITS("activity_consume_credits", null) {
            /**
             *
             * @param values 积分数量,自定义map
             * @return
             */
            @Override
            public Map<String, Object> builder(Object... values) {
                Map<String, Object> map = new HashMap<>();
                map.put(EVENT_TYPE, filed);
                String[] files={"consume_credits"};
                for (int i = 0; i < files.length; i++) {
                    if(values!=null&& values.length>=i){
                        map.put(files[i],values[i]);
                    }
                }
                dealCustom(map, values);
                return map;
            }

            @Override
            public Map<String, Object> builder(HttpServletRequest request) {
                return builder();
            }
        },


        ;
        final String filed;
        /**
         * 旧版本相关编号
         */
        final Integer oldCode;

        public static final String EVENT_TYPE = "event_type";

        /**
         * 自定义内容前缀
         */
        public static final String CUSTOM_PREF = "custom_";

        /**
         * 构建eventType内容
         *
         * @param values
         * @return
         */
        public abstract Map<String, Object> builder(Object... values);


        public abstract Map<String, Object> builder(HttpServletRequest request);

        /**
         * 处理自定义内容
         * @param map
         * @param values
         */
        private static void dealCustom(Map<String, Object> map, Object[] values) {
            if (values==null||values.length<=0){
                return;
            }
            for (Object value : values) {
                if(value instanceof Map){
                    Map<String, Object> custom = (Map<String, Object>) value;
                    for (Map.Entry<String, Object> entry : custom.entrySet()) {
                        map.put(CUSTOM_PREF+entry.getKey(),entry.getValue());
                    }

                }
            }
        }



        EventType(String filed, Integer oldCode) {
            this.filed = filed;
            this.oldCode = oldCode;
        }

        public  Integer getOldCode() {
            return oldCode;
        }

        public static boolean checkExist(String eventType) {
            for (EventType type : values()) {
                if (type.filed.equals(eventType)) {
                    return true;
                }
            }
            return false;
        }


        public static EventType getByFiled(String eventType) {
            for (EventType type : values()) {
                if (type.filed.equals(eventType)) {
                    return type;
                }
            }
            return null;
        }
    }


}
