package cn.com.duiba.galaxy.sdk.pay;

import cn.com.duiba.galaxy.sdk.pay.api.AbcPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.AliPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.BocPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.CcbPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.CebXykPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.GdhxPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.IcbcElifePayApi;
import cn.com.duiba.galaxy.sdk.pay.api.UnionPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.WxPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.CiticPayApi;
import cn.com.duiba.galaxy.sdk.pay.api.IcbcPayApi;

/**
 * @author 刘佳辉
 * @since 2022/12/8
 */
public interface PayApi {

    /**
     * 微信支付 todo 未测试
     */
    WxPayApi getWxPayApi();

    /**
     * 支付宝支付 todo 未测试
     * @return
     */
    AliPayApi getAliPayApi();

    /**
     * 中国银行支付 todo 未测试
     * @return BocPayApi
     */
    BocPayApi getBocPayApi();

    /**
     * 农行支付 todo 未测试
     * @return
     */
    AbcPayApi getAbcPayApi();

    /**
     * 建行支付 todo 未测试
     * @return
     */
    CcbPayApi getCcbPayApi();

    /**
     * 中信银行支付 todo 未测试
     * @return
     */
    CiticPayApi getCiticPayApi();

    /**
     * 工行e支付H5 todo 未测试
     * @return
     */
    IcbcPayApi getIcbcPayApi();

    /**
     * 工行e生活支付（app端 && 微信小程序端） todo 未测试
     * @return
     */
    IcbcElifePayApi getIcbcElifePayApi();

    /**
     * 浙江银联支付 todo 未测试
     * @return
     */
    UnionPayApi getUnionPayApi();

    /**
     * 中国光大银行信用卡中心支付 todo 未测试
     *
     * @return
     */
    CebXykPayApi getCebXykPayApi();

    /**
     * 广东华兴银行支付 todo 未测试
     * @return
     */
    GdhxPayApi getGdhxPayApi();

}
