package cn.com.duiba.galaxy.sdk.pay.api;

import cn.com.duiba.galaxy.sdk.pay.BaseRefundResp;
import cn.com.duiba.galaxy.sdk.pay.citic.CiticPayCenterCallbackNotifyResponse;
import cn.com.duiba.galaxy.sdk.pay.citic.CiticPayCenterChargeNotifyResponse;
import cn.com.duiba.galaxy.sdk.pay.citic.CiticPayCenterRefundRequest;
import cn.com.duiba.galaxy.sdk.pay.citic.CiticWapPayCenterChargeRequest;
import cn.com.duiba.galaxy.sdk.pay.citic.CiticWapPayCenterChargeResponse;
import cn.com.duiba.galaxy.sdk.exception.BizRuntimeException;


/**
 * Created by HePeng on 2020/11/05 14:57.
 */
public interface CiticPayApi {
    /**
     * 发起支付
     * @param chargeRequest
     * @return
     * @throws BizRuntimeException
     */
    CiticWapPayCenterChargeResponse createCiticCharge(CiticWapPayCenterChargeRequest chargeRequest) throws BizRuntimeException;

    /**
     * 查询支付结果
     * @param bizOrderNo
     * @param bizType
     * @return
     * @throws BizRuntimeException
     */
    CiticPayCenterChargeNotifyResponse queryOrderNotify(String bizOrderNo, Integer bizType) throws BizRuntimeException;

    /**
     * 发起退款
     * @param request
     * @return
     */
    BaseRefundResp citicRefund(CiticPayCenterRefundRequest request);


    /**
     * 后端回调通知
     *
     * @param content 开发者回调通知信息
     * @return
     */
    CiticPayCenterCallbackNotifyResponse callbackNotify(String content);
}
