package cn.com.duiba.galaxy.sdk.pay.ccb;

import cn.com.duiba.galaxy.sdk.pay.BasePayReq;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 建行支付请求
 *
 * @author fxr
 * @date 2020-6-30
 */
public class CcbChargeRequest extends BasePayReq {

    private static final long serialVersionUID = 7029253460204294941L;

    /**
     * 业务ID，业务方根据需要自定义，可不传
     */
    private String bizId;

    /**
     * 支付金额，单位为分
     */
    @NotNull(message = "支付金额必填")
    @Min(value = 1, message = "最少支付一分钱")
    private Integer amount;

    /**
     * 商户柜台代码
     * 区分钱支付到哪个供应商
     * <p>
     * cn.com.duiba.activity.custom.center.api.enums.ccb.EnumSupplierEntityEnum#getCode()
     */
    @NotNull(message = "商户柜台代码必填")
    private String posId;


    /**
     * 客户端ip
     */
    @Size(max = 16, message = "ip的长度超过16")
    private String ip;

    /**
     * 商品描述
     */
    @Size(max = 255, message = "商品描述超过255")
    @NotNull(message = "商品详情不能为空")
    private String goodsDetail;

    /**
     * 传给建行
     * 建行回传
     */
    private String remark1;

    /**
     * 传给建行
     * 建行回传
     */
    private String remark2;

    /**
     * 支付结果通知的地址，不传则走默认配置
     * 注：建行本不支持动态传支付通知URL,这里的地址，只是用于在trade-access-web 收到通知后，转发通知请求到该URL
     */
    private String resultNotifyUrl;

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getPosId() {
        return posId;
    }

    public void setPosId(String posId) {
        this.posId = posId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getGoodsDetail() {
        return goodsDetail;
    }

    public void setGoodsDetail(String goodsDetail) {
        this.goodsDetail = goodsDetail;
    }

    public String getRemark1() {
        return remark1;
    }

    public void setRemark1(String remark1) {
        this.remark1 = remark1;
    }

    public String getRemark2() {
        return remark2;
    }

    public void setRemark2(String remark2) {
        this.remark2 = remark2;
    }

    public String getResultNotifyUrl() {
        return resultNotifyUrl;
    }

    public void setResultNotifyUrl(String resultNotifyUrl) {
        this.resultNotifyUrl = resultNotifyUrl;
    }
}
