/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba;

import cn.com.duiba.utils.JarUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class CheckJars {
    private static final String START_MSG = ":\u5f00\u59cb\u68c0\u67e5jar\u51b2\u7a81\r\n";
    private static final String END_TMSG = "\r\n:jar\u51b2\u7a81\u68c0\u67e5\u5b8c\u6210\r\n";
    private static final String JAR_HEADER_MSG = "\r\nWARN: \u68c0\u6d4b\u5230\u4ee5\u4e0b\u591a\u4e2ajar\u51b2\u7a81: \r\n";
    private static final String JAR_MSG = "\t--:%s\r\n";
    private static final String CLASS_HEADER_MSG = "      \u51b2\u7a81\u7684class\u5982\u4e0b\r\n";
    private static final String CLASS_MSG = "\t--:%s\r\n";
    private static final String CLASS_MORE_MSG = "\t......\r\n";
    private static final String NOTFOUND_MSG = "\r\n--\u672a\u53d1\u73b0\u51b2\u7a81\u7684jar\r\n";
    private static final List<String> WHITE_LIST = Arrays.asList("org/apache/commons/collections", "org/apache/commons/logging", "org/apache/xbean/recipe", "org/apache/juli", "io/netty", "javax/xml/stream", "javax/annotation", "javax/ws/rs", "org/xmlpull/v1", "org/aspectj", "org/aopalliance/aop", "org/aopalliance/intercept", "org/codehaus/plexus/component/builder/XBeanComponentBuilder");

    private CheckJars() {
    }

    public static String check(List<File> files, boolean isWhiteMode) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (File file : files) {
            List<String> classNames = JarUtils.getJarClasses(file.getAbsolutePath());
            for (String className : classNames) {
                if (isWhiteMode && CheckJars.checkWhite(className)) continue;
                multimap.put((Object)className, (Object)file.getAbsolutePath());
            }
        }
        return String.format("%s%s%s", START_MSG, CheckJars.buildWarnMsg((Multimap<String, String>)multimap), END_TMSG);
    }

    private static boolean checkWhite(String className) {
        if (StringUtils.isBlank((String)className)) {
            return false;
        }
        for (String white : WHITE_LIST) {
            if (!className.contains(white)) continue;
            return true;
        }
        return false;
    }

    private static String buildWarnMsg(Multimap<String, String> multimap) {
        if (multimap == null) {
            return null;
        }
        ArrayListMultimap invertMap = ArrayListMultimap.create();
        Multimaps.invertFrom(multimap, (Multimap)invertMap);
        HashSet<WarnMsgModel> models = new HashSet<WarnMsgModel>();
        for (String className : multimap.keySet()) {
            ArrayList<String> jars = new ArrayList<String>(multimap.get((Object)className));
            if (jars.size() <= 1) continue;
            ArrayList<String> cnsResult = new ArrayList<String>();
            for (String jarPath : jars) {
                ArrayList cns = new ArrayList(invertMap.get((Object)jarPath));
                if (cnsResult.isEmpty()) {
                    cnsResult.addAll(cns);
                    continue;
                }
                cnsResult.retainAll(cns);
            }
            WarnMsgModel model = new WarnMsgModel();
            model.setJars(jars);
            model.setClassNames(cnsResult);
            models.add(model);
        }
        return CheckJars.innerBuildWarnMsg(models);
    }

    private static String innerBuildWarnMsg(Set<WarnMsgModel> models) {
        StringBuilder msgBuilder = new StringBuilder();
        block0: for (WarnMsgModel model : models) {
            List<String> jars = model.getJars();
            List<String> classNames = model.getClassNames();
            msgBuilder.append(JAR_HEADER_MSG);
            for (String jar : jars) {
                msgBuilder.append(String.format("\t--:%s\r\n", jar));
            }
            msgBuilder.append(CLASS_HEADER_MSG);
            for (int i = 0; i < classNames.size(); ++i) {
                if (i > 2) {
                    msgBuilder.append(CLASS_MORE_MSG);
                    continue block0;
                }
                msgBuilder.append(String.format("\t--:%s\r\n", classNames.get(i)));
            }
        }
        if (msgBuilder.length() == 0) {
            return NOTFOUND_MSG;
        }
        return msgBuilder.toString();
    }

    public static void main(String[] args) {
        ArrayList<String> jars = new ArrayList<String>();
        jars.add("aaa");
        jars.add("bbb");
        ArrayList<String> jars2 = new ArrayList<String>();
        jars2.add("bbb");
        jars2.add("aaa");
        WarnMsgModel model1 = new WarnMsgModel();
        model1.setJars(jars);
        WarnMsgModel model2 = new WarnMsgModel();
        model2.setJars(jars2);
        System.out.println(model1.equals(model2));
        System.out.println(model1.hashCode());
        System.out.println(model2.hashCode());
    }

    private static class WarnMsgModel {
        private List<String> jars;
        private List<String> classNames;

        public WarnMsgModel() {
        }

        public WarnMsgModel(List<String> jars, List<String> classNames) {
            this.jars = jars;
            this.classNames = classNames;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WarnMsgModel)) {
                return false;
            }
            WarnMsgModel that = (WarnMsgModel)o;
            List<String> thatJars = that.getJars();
            if (thatJars.size() != this.jars.size()) {
                return false;
            }
            for (String it : thatJars) {
                if (this.jars.contains(it)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            for (String it : this.jars) {
                hashCode += it.hashCode();
            }
            return hashCode;
        }

        public List<String> getJars() {
            return this.jars;
        }

        public void setJars(List<String> jars) {
            this.jars = jars;
        }

        public List<String> getClassNames() {
            return this.classNames;
        }

        public void setClassNames(List<String> classNames) {
            this.classNames = classNames;
        }
    }
}

