package cn.com.duiba.live.activity.center.api.remoteservice.community.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.community.invitation.CommunityInvitationRulesDto;
import java.util.List;

/**
 * @author ouyang
 * @date 2022-05-25 11：09
 * @description 社群邀约规则 Service
 */
@AdvancedFeignClient
public interface RemoteCommunityInvitationRulesService {


    /**
     * 获取社群邀约规则
     *
     * @param companyId  公司Id
     * @return 获取社群邀约规则列表
     */
    List<CommunityInvitationRulesDto> findByCompanyId(Long companyId);

    /**
     * 获取社群邀约规则
     *
     * @param configId  邀约活动配置id
     * @return 获取社群邀约规则列表
     */
    List<CommunityInvitationRulesDto> findByConfigId(Long configId);


    /**
     * 获取社群邀约规则
     *
     * @param id  id
     * @return 社群邀约规则
     */
    CommunityInvitationRulesDto findById(Long id);

    /**
     * 批量更新
     * @param dtoList
     * @return
     */
    Integer batchUpdate(List<CommunityInvitationRulesDto> dtoList);

    /**
     * 批量新增
     * @param dtoList
     * @return
     */
    Integer batchInsert(List<CommunityInvitationRulesDto> dtoList);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    Integer batchDelete(List<Long> ids);

    /**
     * 消费库存
     *
     * @param id 主建
     * @param goodsCurrentNum 当前库存
     * @param consumeNum 消费数量
     * @return 执行结果
     */
    Integer consumeInventory(Long id,Integer goodsCurrentNum,Integer consumeNum);

    /**
     * 增加库存
     *
     * @param id 主建
     * @param goodsTotalNum 库存总数
     * @param goodsCurrentNum 当前库存
     * @param addNum 增加数量
     * @return 执行结果
     */
    Integer addInventory(Long id,Integer goodsTotalNum,Integer goodsCurrentNum,Integer addNum);

}
