package cn.com.duiba.live.activity.center.api.remoteservice.goodauth;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.goodauth.LiveGoodAuthDto;

/**
 * @Description
 * @Date 2022/5/19 18:08
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteLiveGoodAuthService {

    /**
     * 根据consumerId查询用户认证信息
     * @param consumerId
     * @return
     */
    LiveGoodAuthDto findByConsumerId(Long consumerId);

    /**
     * 根据partnerUserId和appId查询用户认证信息
     * @param partnerUserId 直播用户ID
     * @param appId
     * @return
     */
    LiveGoodAuthDto findByPartnerUserIdAndAppId(Long partnerUserId, Long appId);

    /**
     * 新增用户认证信息
     * @param liveGoodAuthDto
     * @return
     */
    Long insert(LiveGoodAuthDto liveGoodAuthDto);
}
