package cn.com.duiba.live.activity.center.api.remoteservice.market;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.market.MarketActivityDto;
import cn.com.duiba.live.activity.center.api.param.market.MarketActivitySearchParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/10/19 5:13 下午
 */
@AdvancedFeignClient
public interface RemoteMarketActivityService {

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    MarketActivityDto selectById(Long id);

    /**
     * 新增一条记录
     *
     * @param marketActivityDto
     * @return
     */
    Long insert(MarketActivityDto marketActivityDto);

    /**
     * 根据id修改记录
     *
     * @param marketActivityDto
     * @return
     */
    Integer updateById(MarketActivityDto marketActivityDto);

    /**
     * 根据id删除记录
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);

    /**
     * 根据条件查询记录
     *
     * @return
     */
    List<MarketActivityDto> listByParam(MarketActivitySearchParam param);

    /**
     * 根据条件查询记录条数
     *
     * @return
     */
    Integer countByParam(MarketActivitySearchParam param);
}
