package cn.com.duiba.live.activity.center.api.enums.welfarerain;

import java.util.HashMap;
import java.util.Map;

public enum WelfareRainTypeEnum {

    VERIFICATION(1,"核销版"),
    LITTLE_DEPOSIT(2,"小额版"),
    ;

    Integer type;

    String desc;

    private static final Map<Integer, WelfareRainTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(WelfareRainTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getType(), tmp);
        }
    }

    public static WelfareRainTypeEnum getByType(Integer rainType) {
        return ENUM_MAP.get(rainType);
    }

    WelfareRainTypeEnum(Integer rainType, String desc) {
        this.type = rainType;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
