package cn.com.duiba.live.activity.center.api.dto.guide;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author xujing
 * @Date 2020/12/4 6:09 下午
 */
@Data
public class LiveGuideNodeDto implements Serializable {
    private static final long serialVersionUID = -598417435867947571L;
    private Long id;

    /**
    * 删除：1已删除，0-未删除
    */
    private Integer deleted;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 直播ID
    */
    private Long liveId;

    /**
    * 互动活动ID
    */
    private Long interactId;

    /**
    * 节点类型:1-资料，2-抽奖，3-红包，4-福利雨，5-爆款预约
    */
    private Integer nodeType;

    /**
    * 排序值
    */
    private Integer sortNum;

    /**
     * 是否可预约：1-可预约，0-不可预约
     */
    private Integer appointmentAble;

    /**
     * 预约基础值
     */
    private Date openTime;
    /**
     * 预约基础值
     */
    private Integer baseNum;

    /**
     * 图标图片
     */
    private String nodeImg;

    /**
     * 图标图片
     */
    private String nodeTitle;

    /**
     * 前景图片
     */
    private String frontImg;

    /**
     * 展示状态：1-已展示，2-展示中，3-待展示
     */
    private Integer showStatus;

    /**
     * 爆款类型：1-顺序，2-上新，3-热销
     */
    private Integer boomType;
    /**
     * 爆款类型：1-讲解，2-预热
     */
    private Integer operateType;
}
