package cn.com.duiba.live.activity.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.red.LiveRedHelpVisitorIdDto;
import cn.com.duiba.live.activity.center.api.dto.red.LiveVisitorHelpDto;

import java.util.List;
import java.util.Map;

/**
 * 红包助力
 * @author lizhi
 * @date 2020/6/19 8:37 PM
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorHelpService {

    /**
     * 保存助力信息
     * @param dto 助力信息
     * @return 执行结果
     */
    int saveHelp(LiveVisitorHelpDto dto);

    /**
     * 保存助力信息
     * @param dto 助力信息
     * @return 主键
     */
    Long save(LiveVisitorHelpDto dto);

    /**
     * 根据主键集合查询助力信息
     * @param ids 主键集合
     * @return 助力信息
     */
    List<LiveVisitorHelpDto> findByIds(List<Long> ids);

    /**
     * 获取访客助力人数
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorId 访客ID
     * @return 助力人数
     */
    long getHelpNum(Long liveId, Long id, Long visitorId);

    /**
     * 批量获取访客助力人数
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorIdList 访客ID集合
     * @return key：访客ID，value：助力人数
     */
    Map<Long, Long> batchGetHelpNum(Long liveId, Long id, List<Long> visitorIdList);

    /**
     * 批量查询助力人的ID集合
     * @param liveId 直播ID
     * @param confRedPacketId 红包ID
     * @param inviterIdList 邀请人ID
     * @return 助力人ID集合
     */
    List<LiveRedHelpVisitorIdDto> batchSelectVisitorIds(Long liveId, Long confRedPacketId, List<Long> inviterIdList);

    /**
     * 批量查询访客邀请人
     * @param liveId 直播ID
     * @param visitorIdList 访客ID集合
     * @return key：访客ID，value：邀请人ID
     */
    Map<Long, Long> batchSelectInviterId(Long liveId, List<Long> visitorIdList);
}
