package cn.com.duiba.live.activity.center.api.enums.fission;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2021/8/5 21:34
 */
public enum FissionAchieveStatusEnum {
    /**
     * 1-进行中 2-切换商品 3-待领取 4-已完成
     */
    INVITING(1, "进行中"),
    CHANGE(2, "切换商品"),
    NOT_DRAW(3, "待领取"),
    FINISH(4, "已完成"),
    STEP_FIRST(5, "一阶段达成"),
    REFUSE_CHANGE(6, "拒绝切换"),
    ;

    Integer activityStatus;

    String desc;

    FissionAchieveStatusEnum(Integer activityStatus, String desc) {
        this.activityStatus = activityStatus;
        this.desc = desc;
    }

    public Integer getActivityStatus() {
        return activityStatus;
    }

    public String getDesc() {
        return desc;
    }
    private static final Map<Integer, FissionAchieveStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(FissionAchieveStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getActivityStatus(), tmp);
        }
    }

    public static FissionAchieveStatusEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

}
