package cn.com.duiba.live.activity.center.api.enums.red;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author chengsiyi
 * @date 2021/4/7 16:12
 */
public enum DoubleRedRewardStatusEnum {
    /**
     * 奖励状态
     */
    FIRST_STEP(1, "第一步"),
    SECOND_STEP(2, "第二步"),
    THIRD_STEP(3, "第三步"),
    RED_WAIT_DRAW(88, "红包待领取"),
    SUCCESS(99, "成功"),
    ;
    private static final Map<Integer, DoubleRedRewardStatusEnum> NEXT = new HashMap<>();

    private static final Map<Integer, DoubleRedRewardStatusEnum> ENUM_MAP = new HashMap<>();

    private static final Set<Integer> SHARE = new HashSet<>();

    static {
        NEXT.put(FIRST_STEP.getRewardStatus(), SECOND_STEP);
        NEXT.put(SECOND_STEP.getRewardStatus(), THIRD_STEP);
        NEXT.put(THIRD_STEP.getRewardStatus(), SUCCESS);
        SHARE.add(FIRST_STEP.getRewardStatus());
        SHARE.add(SECOND_STEP.getRewardStatus());
        for(DoubleRedRewardStatusEnum tmp : values()){
            ENUM_MAP.put(tmp.getRewardStatus(), tmp);
        }
    }


    public static DoubleRedRewardStatusEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }


    public static DoubleRedRewardStatusEnum next(Integer code) {
        return NEXT.get(code);
    }

    public static boolean canShare (Integer code){
        return SHARE.contains(code);
    }

    Integer rewardStatus;

    String desc;

    DoubleRedRewardStatusEnum(Integer rewardStatus, String desc) {
        this.rewardStatus = rewardStatus;
        this.desc = desc;
    }

    public Integer getRewardStatus() {
        return rewardStatus;
    }

    public String getDesc() {
        return desc;
    }
}
