package cn.com.duiba.live.activity.center.api.remoteservice.welfarerain;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.welfareRain.WelfareRainDeatilQueryDto;
import cn.com.duiba.live.activity.center.api.dto.welfareRain.WelfareRainDetailsDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteWelfareRainDetailsService {
    /**
     * 插入
     * @param dto
     * @return
     */
    Long insertDetails(WelfareRainDetailsDto dto);

    /**
     * 查询
     * @param id
     * @return
     */
    WelfareRainDetailsDto queryById(Long id);

    List<WelfareRainDetailsDto> queryByIds(List<Long> ids);

    /**
     * 条件查询
     * @param dto
     * @return
     */
    List<WelfareRainDetailsDto> findByIdAndType(WelfareRainDeatilQueryDto dto);

    /**
     * 更新操作
     * @param dto
     * @return
     */
    int updateDetails(WelfareRainDetailsDto dto);

    /**
     * 批量会写操作
     * @param confId
     * @param ids
     * @return
     */
    Boolean batchInsertConfId(Long confId, List<Long> ids);

    /**
     * 根据主键批量查询
     * @param idlist
     * @return
     */
    List<WelfareRainDetailsDto> batchQuery(List<Long> idlist);

    /**
     * 主键删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 批量删除
     * @param ids
     * @return
     */
    Integer batchDelete(List<Long> ids);

    /**
     * 根据配置主键查询详情信息
     * @param conflist
     * @return
     */
    List<WelfareRainDetailsDto> batchQueryByConfids(List<Long> conflist);

    /**
     * 批量插入
     * @param dto
     * @return
     */
    Integer batchInsert(List<WelfareRainDetailsDto> dto);

    /**
     * 批量更新
     * @param dto
     * @return
     */
    Integer batchUpdate(List<WelfareRainDetailsDto> dto);


    /**
     * 根据福利雨ids和类型列表
     * 批量查询
     * @param ids 不可为空
     * @param types 可为空，空查询全部
     * @return
     */
    List<WelfareRainDetailsDto> listByRainconfIdsAndTypes(List<Long> ids,List<Integer> types);


}
