package cn.com.duiba.live.activity.center.api.dto.red.platform;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 平台红包领取记录
 */
@Data
public class LivePlatformRedpacketReceiveDto implements Serializable {

    private static final long serialVersionUID = -244155232816854807L;
    /**
     * 自增ID
     */
    private Long id;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 互动配置ID
     */
    private Long confId;

    /**
     * 用户ID
     */
    private Long liveUserId;

    /**
     * 奖励表ID
     */
    private Long rewardId;

    /**
     * 领取方式
     *
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.DrawTypeEnum
     */
    private Integer drawType;

    /**
     * 单个金额
     */
    private Integer singleAmount;

    /**
     * 领取记录:1-未领取2-领取中，3-中间态，4-领取成功，5-领取失败
     *
     * @see cn.com.duiba.live.activity.center.api.enums.live.LiveRedPacketReceiveStatusEnum
     */
    private Integer receiveStatus;

    /**
     * 电话号码
     */
    private String phoneNum;

    /**
     * 三方返回信息
     */
    private String thirdMessage;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}

