package cn.com.duiba.live.activity.center.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.LiveMarketActivityDto;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.LiveFissionAchieveConfigDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/8/4 19:20
 */
@AdvancedFeignClient
public interface RemoteLiveMarketActivityService {

    /**
     * 根据直播间活动ID查询活动
     * @param id
     * @return
     */
    LiveMarketActivityDto findById(Long id);

    /**
     * 根据直播间活动ID查询活动
     * @param ids
     * @return
     */
    List<LiveMarketActivityDto> findByIds(List<Long> ids);

    /**
     * 获取直播间营销活动
     * @param liveId not null 直播ID
     * @param activityType null 活动类型 {@link cn.com.duiba.live.activity.center.api.enums.fission.FissionActivityTypeEnum}
     * @return
     */
    List<LiveMarketActivityDto> findByLiveId(Long liveId, Integer activityType);

    /**
     * 获取直播间 达标必得 活动
     * @param liveId
     * @return
     */
    List<LiveFissionAchieveConfigDto> getFissionAchieveConfig(Long liveId, Long liveActivityId);

    /**
     * 批量保存直播间活动
     * @param dtos dtos
     * @return 结果
     */
    Integer batchSave(List<LiveMarketActivityDto> dtos);

    /**
     * 删除活动
     * @param id
     * @return
     */
    Integer delete(Long id);

    /**
     * 删除活动直播间的
     * @param liveId
     * @return
     */
    Integer deleteByLiveId(Long liveId);

    /**
     * 获取活动关联的直播间是否被上架
     * @param activityId
     * @return
     */
    Boolean getOnShelf (Long activityId);

    /**
     * 获取活动是直播间中的唯一活动
     * @param activityId
     * @return
     */
    Boolean sole (Long activityId);
}
