package cn.com.duiba.live.activity.center.api.remoteservice.fission.achieve;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.LiveFissionAchieveRecordDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/8/4 19:19
 */
@AdvancedFeignClient
public interface RemoteLiveFissionAchieveRecordService {

    /**
     * 根据ID查找记录
     * @param id id
     * @return 参与记录
     */
    LiveFissionAchieveRecordDto findById(Long id);

    /**
     * 批量获取参与记录
     * @param ids id
     * @return
     */
    List<LiveFissionAchieveRecordDto> findByIds(List<Long> ids);

    /**
     * 保存用户记录
     * @param dto 保存的参数
     * @return 返回插入的ID
     */
    Long saveUserRecord(LiveFissionAchieveRecordDto dto);

    /**
     *
     * @param id id
     * @param activityStatus 现有状态{@link cn.com.duiba.live.activity.center.api.enums.fission.FissionAchieveStatusEnum}
     * @param expectStatus 更新状态 {@link cn.com.duiba.live.activity.center.api.enums.fission.FissionAchieveStatusEnum}
     * @return 更新结果
     */
    Integer updateStatus(Long id, Integer activityStatus, Integer expectStatus);

    /**
     * 强制更新记录至目标状态，不校验当前记录状态
     * @param ids
     * @param expectStatus
     * @return
     */
    Integer forceBatchUpdateStatus(List<Long> ids, Integer expectStatus);

    /**
     * 批量更新记录状态
     * @param ids 记录ID
     * @param activityStatus 现有状态{@link cn.com.duiba.live.activity.center.api.enums.fission.FissionAchieveStatusEnum}
     * @param expectStatus 更新状态 {@link cn.com.duiba.live.activity.center.api.enums.fission.FissionAchieveStatusEnum}
     * @return 更新结果
     */
    Integer batchUpdateStatus(List<Long> ids, Integer activityStatus, Integer expectStatus);

    /**
     * 获取用户在达标必得活动下的所有记录
     * @param liveId 直播ID not null
     * @param liveUserId 用户ID not null
     * @param liveActivityId 直播间活动ID null 返回所有记录
     * @return 参与记录
     */
    List<LiveFissionAchieveRecordDto> getUserRecord(Long liveId, Long liveUserId, Long liveActivityId);


    /**
     * 获取成功的记录，按照时间倒序
     * @param liveId 直播ID
     * @param liveActivityId 直播间活动ID
     * @param count 数量,默认20，不超过100
     * @return
     */
    List<LiveFissionAchieveRecordDto> getFinishRecord(Long liveId, Long liveActivityId, Integer count);


}
