package cn.com.duiba.live.activity.center.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.clue.LiveRedPacketReceiveDto;
import cn.com.duiba.live.activity.center.api.enums.live.LiveRedPacketStatusEnum;
import cn.com.duiba.live.activity.center.api.dto.red.LiveConfRedPacketDto;
import cn.com.duiba.live.activity.center.api.dto.red.LiveStatisticsRedPacketDto;
import cn.com.duiba.live.activity.center.api.dto.red.LiveVisitorHelpDto;
import cn.com.duiba.kjy.livecenter.api.param.clue.LiveRedPacketReceiveSearchParam;
import cn.com.duiba.live.activity.center.api.param.red.LiveConfRedPacketSearchParam;
import cn.com.duiba.kjy.livecenter.api.param.red.LiveRedPacketReceiveParam;
import cn.com.duiba.live.activity.center.api.param.red.LiveVisitorHelpSearchParam;

import java.util.List;

/**
 * 直播红包相关
 * @author lizhi
 * @date 2020/4/3 1:33 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRedPacketService {

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播配置-红包相关配置集合
     */
    List<LiveConfRedPacketDto> findList(LiveConfRedPacketSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long findCount(LiveConfRedPacketSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播配置-红包相关配置
     */
    LiveConfRedPacketDto findById(Long id);

    /**
     * 批量逻辑删除
     * @param idList 主键集合
     * @return 执行结果
     */
    int batchDelete(List<Long> idList);

    /**
     * 新增
     * @param dto 直播配置-红包相关配置
     * @return 执行结果
     */
    int insert(LiveConfRedPacketDto dto);

    /**
     * 更新
     * @param dto 直播配置-红包相关配置
     * @return 执行结果
     */
    int update(LiveConfRedPacketDto dto);

    /**
     * 更新状态
     * @param dto 直播配置-红包相关配置
     * @param expectedRedStatus 预期现有状态
     * @see LiveRedPacketStatusEnum
     * @return 执行结果
     */
    int updateStatus(LiveConfRedPacketDto dto, Integer expectedRedStatus);

    /**
     * 批量领取红包
     * @param id 红包配置主键
     * @param amount 领取金额
     * @param num 领取数量
     * @return 执行结果
     */
    int batchReceiveRedPacket(Long id, Integer amount, Integer num);

    /**
     * 批量领取手气王红包
     * @param id 红包配置主键
     * @param num 领取数量
     * @return 执行结果
     */
    int batchReceiveLuckRedPacket(Long id, Integer num);



    /**
     * 保存助力信息
     * @param dto 助力信息
     * @return 执行结果
     */
    @Deprecated
    int saveHelp(LiveVisitorHelpDto dto);

    /**
     * 新增或更新开播红包
     * @param dto 红包信息
     * @return 红包主键
     */
    @Deprecated
    Long saveOrUpdateStartLive(LiveConfRedPacketDto dto);

    /**
     * 直播红包
     * @param liveId 直播ID
     * @return 执行结果
     */
    @Deprecated
    int deleteStartLiveRed(Long liveId);

    /**
     * 新增或更新实时红包
     * @param dto 红包信息
     * @return 红包主键
     */
    @Deprecated
    Long saveOrUpdateRealTime(LiveConfRedPacketDto dto);

    /**
     * 更新开播红包开抢时间
     * @param liveId 直播ID
     * @return 执行结果
     */
    @Deprecated
    int updateStartLiveRedPacketTime(Long liveId);

    /**
     * 根据直播ID查询
     * @param liveId 直播ID
     * @return 直播配置-红包统计数据
     */
    @Deprecated
    LiveStatisticsRedPacketDto findStatisticsByLiveId(Long liveId);

    /**
     * 从缓存中查询开播红包
     * @param liveId 查询条件
     * @return 直播配置-开播红包
     */
    @Deprecated
    LiveConfRedPacketDto findStartLiveRedPacketFromCache(Long liveId);

    /**
     * 从缓存中查询未领取完的实时红包
     * @param liveId 查询条件
     * @return 直播配置-开播红包
     */
    @Deprecated
    LiveConfRedPacketDto findUnfinishedRealTimeRedPacketFromCache(Long liveId);

    /**
     * 根据直播ID和访客ID查询助力信息
     * @param liveId 直播ID
     * @param visitorId 访客ID
     * @return 助力信息
     */
    @Deprecated
    LiveVisitorHelpDto findHelpByLiveAndVisitor(Long liveId, Long visitorId);

    /**
     * 获取访客助力人数
     * @param liveId 直播ID
     * @param id 红包ID
     * @param visitorId 访客ID
     * @return 助力人数
     */
    @Deprecated
    long getHelpNum(Long liveId, Long id, Long visitorId);

    /**
     * 分页查询助力关系
     * @param param 分页参数
     * @return 直播-助力关系集合
     */
    @Deprecated
    List<LiveVisitorHelpDto> findHelpPage(LiveVisitorHelpSearchParam param);

    /**
     * 领取红包
     * @param param 领红包参数
     * @return 领红包记录
     */
    @Deprecated
    LiveRedPacketReceiveDto receiveRedPacket(LiveRedPacketReceiveParam param);

    /**
     * 根据领取记录ID，查询红包结果
     * @param receiveId 领取记录ID
     * @return 领取结果
     */
    @Deprecated
    LiveRedPacketReceiveDto findReceiveById(Long receiveId);

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播红包领取记录集合
     */
    @Deprecated
    List<LiveRedPacketReceiveDto> findReceivePage(LiveRedPacketReceiveSearchParam param);
}
