package cn.com.duiba.live.activity.center.api.remoteservice.welfarerain;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.welfareRain.WelfareRainCollectDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2020/10/26 23:07
 */
@AdvancedFeignClient
public interface RemoteWelfareRainDataService {

    /**
     * 是否需要收集用户
     * @param liveId 直播ID
     * @return true-需要收集，false-不需要
     */
    boolean needCollect(Long liveId);

    /**
     * 收集用户信息
     * @param userList 用户信息
     */
    void collect(List<WelfareRainCollectDto> userList);
}
