package cn.com.duiba.live.activity.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/6/21 20:05
 */
public enum UserCollectTypeEnum {

    /**
     * 采集类型
     */
    RED_PACKET(1, "红包"),
    MULTI_PRIZE(2, "多奖项抽奖"),
    LOTTERY(3, "抽奖"),
    ;

    Integer collectType;

    String desc;

    UserCollectTypeEnum(Integer collectType, String desc) {
        this.collectType = collectType;
        this.desc = desc;
    }
    private static final Map<Integer, UserCollectTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(UserCollectTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCollectType(), tmp);
        }
    }

    public static UserCollectTypeEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }


    public Integer getCollectType() {
        return collectType;
    }

    public String getDesc() {
        return desc;
    }
}
