package cn.com.duiba.live.activity.center.api.param.doublered;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author chengsiyi
 * @date 2021/4/9 17:52
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class DoubleRedRecordPageQueryParam extends PageQuery implements Serializable {
    private static final long serialVersionUID = 1134141086677710083L;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 直播间用户id
     */
    private Long liveUserId;

    /**
     * 红包类型 1红包 2抽奖码
     */
    private Integer redType;

    /**
     * 红包配置id
     */
    private Long confId;

    /**
     * 奖励状态
     *
     * @see cn.com.duiba.live.activity.center.api.enums.red.DoubleRedRewardStatusEnum
     */
    private Integer rewardStatus;
}
