/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.activity.center.api.enums.fission;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum FissionAchieveStatusEnum {
    INVITING(1, "\u8fdb\u884c\u4e2d"),
    CHANGE(2, "\u5207\u6362\u5546\u54c1"),
    NOT_DRAW(3, "\u5f85\u9886\u53d6"),
    FINISH(4, "\u5df2\u5b8c\u6210"),
    STEP_FIRST(5, "\u4e00\u9636\u6bb5\u8fbe\u6210"),
    REFUSE_CHANGE(6, "\u62d2\u7edd\u5207\u6362"),
    FIRST_REFUSE_CHANGE(7, "\u4e00\u9636\u6bb5\u8fbe\u6210\u62d2\u7edd\u5207\u6362");

    Integer activityStatus;
    String desc;
    private static final Map<Integer, FissionAchieveStatusEnum> ENUM_MAP;
    private static final Set<Integer> PROCESS_STATUS;
    private static final Set<Integer> REFUSE_CHANGE_STATUS;
    private static final List<Integer> ALL_STATUS;

    private FissionAchieveStatusEnum(Integer activityStatus, String desc) {
        this.activityStatus = activityStatus;
        this.desc = desc;
    }

    public Integer getActivityStatus() {
        return this.activityStatus;
    }

    public String getDesc() {
        return this.desc;
    }

    public static FissionAchieveStatusEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

    public static boolean isProcess(Integer activityStatus) {
        return PROCESS_STATUS.contains(activityStatus);
    }

    public static boolean isRefuseChange(Integer activityStatus) {
        return REFUSE_CHANGE_STATUS.contains(activityStatus);
    }

    static {
        ENUM_MAP = new HashMap<Integer, FissionAchieveStatusEnum>();
        for (FissionAchieveStatusEnum tmp : FissionAchieveStatusEnum.values()) {
            ENUM_MAP.put(tmp.getActivityStatus(), tmp);
        }
        PROCESS_STATUS = Sets.newHashSet((Object[])new Integer[]{INVITING.getActivityStatus(), STEP_FIRST.getActivityStatus(), REFUSE_CHANGE.getActivityStatus(), FIRST_REFUSE_CHANGE.getActivityStatus()});
        REFUSE_CHANGE_STATUS = Sets.newHashSet((Object[])new Integer[]{REFUSE_CHANGE.getActivityStatus(), FIRST_REFUSE_CHANGE.getActivityStatus()});
        ALL_STATUS = Lists.newArrayList((Object[])new Integer[]{INVITING.getActivityStatus(), CHANGE.getActivityStatus(), NOT_DRAW.getActivityStatus(), FINISH.getActivityStatus(), STEP_FIRST.getActivityStatus(), REFUSE_CHANGE.getActivityStatus(), FIRST_REFUSE_CHANGE.getActivityStatus()});
    }
}

