package cn.com.duiba.live.activity.center.api.enums.fission;

import java.util.HashMap;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/8/4 20:58
 */
public enum FissionActivityTypeEnum {

    /**
     * 裂变活动类型
     */
    ACHIEVE(1, "达标必得"),
    MULTI_PRIZE(2, "多奖项抽奖"),
    FLIP_WORD(3, "集卡"),

    ;

    Integer activityType;

    String desc;

    private static final Map<Integer, FissionActivityTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (FissionActivityTypeEnum tmp : values()) {
            ENUM_MAP.put(tmp.getActivityType(), tmp);
        }
    }

    FissionActivityTypeEnum(Integer activityType, String desc) {
        this.activityType = activityType;
        this.desc = desc;
    }

    public static FissionActivityTypeEnum of(Integer code) {
        return ENUM_MAP.get(code);
    }

    public Integer getActivityType() {
        return activityType;
    }

    public String getDesc() {
        return desc;
    }
}
