package cn.com.duiba.live.activity.center.api.dto.credit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenhang
 * @date 2021/8/16 8:21 下午
 */
@Data
public class CreditCardActivityDto implements Serializable {

    private static final long serialVersionUID = -4600003601660211827L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 开始时间
     */
    private Date beginTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 活动类型 0:进件礼
     */
    private Integer activityType;

    /**
     * 链接配置
     */
    private String activityLink;

    /**
     * 奖励类型 0:抽奖 1:限定购买
     */
    private Integer rewardType;

    /**
     * h5链接
     */
    private String rewardLink;

    /**
     * 扩展字段
     */
    private String extraInfo;

    /**
     * 状态 0:未启用 1:启用 2:暂停
     */
    private Integer publishState;

    /**
     * 新增活动模板链接
     */
    private String landingPage;
}
