package cn.com.duiba.live.activity.center.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.FissionActivityDto;
import cn.com.duiba.live.activity.center.api.param.fission.FissionActivitySearchParam;

import java.util.List;

/**
 * 裂变活动
 * @author chengsiyi
 * @date 2021/8/4 19:18
 */
@AdvancedFeignClient
public interface RemoteFissionActivityService {

    /**
     * 获取裂变活动列表
     * @param param 查询参数
     * @return 活动列表
     */
    List<FissionActivityDto> getFissionActivityList(FissionActivitySearchParam param);

    /**
     * 根据ID批量获取
     * @param ids ids
     * @return 活动列表
     */
    List<FissionActivityDto> findByIds(List<Long> ids);

    /**
     * 根据ID获取活动
     * @param id
     * @return
     */
    FissionActivityDto findById(Long id);


    /**
     * 统计
     * @param param
     * @return
     */
    Long selectCount(FissionActivitySearchParam param);

    /**
     * 新增
     * @param dto 裂变活动
     * @return 活动id
     */
    Long save(FissionActivityDto dto);

}
